/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.uirandom;

import com.jslope.uirandom.RandomByteKeeper;
import com.jslope.uirandom.UpdateListener;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class JSeederDialog
extends JDialog
implements ActionListener,
UpdateListener {
    JProgressBar progressBar;
    RandomByteKeeper randomByteKeeper;

    public JSeederDialog(Frame parent, int seedBytes) {
        super(parent, "RandomByteKeeper Dialog", true);
        this.setupWindow(seedBytes);
    }

    public byte[] getInternalSeed() {
        return this.randomByteKeeper.getSeed();
    }

    public void keyTyped(KeyEvent ke) {
        this.progressBar.setValue(this.randomByteKeeper.getCurrentBitIndex());
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.dispose();
    }

    protected void setupWindow(int seedBytes) {
        this.randomByteKeeper = new RandomByteKeeper(seedBytes);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        this.addLabel(panel, " ");
        this.addLabel(panel, "Please type some keys and move mouse other this window ");
        this.addLabel(panel, " ");
        this.addLabel(panel, "to initialize random number generator");
        this.addLabel(panel, " ");
        this.progressBar = new JProgressBar(0, this.randomByteKeeper.getBitLength());
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        panel.add(this.progressBar);
        this.setContentPane(panel);
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(dim.width - 200, dim.height - 200);
        this.setLocation(100, 100);
        this.randomByteKeeper.addActionListener(this);
        this.addKeyListener(this.randomByteKeeper);
        this.addMouseMotionListener(this.randomByteKeeper);
        this.randomByteKeeper.addUpdateListener(this);
    }

    private void addLabel(JPanel panel, String lab) {
        JLabel label = new JLabel(lab);
        Font font = label.getFont();
        Font newFont = new Font(font.getName(), font.getStyle(), font.getSize() + 15);
        label.setAlignmentX(0.5f);
        label.setFont(newFont);
        panel.add(label);
    }

    @Override
    public void update() {
        this.progressBar.setValue(this.randomByteKeeper.getCurrentBitIndex());
    }

    public static byte[] getSeed(Frame window, int i) {
        JSeederDialog dialog = new JSeederDialog(window, i);
        dialog.setVisible(true);
        return dialog.getInternalSeed();
    }
}

