/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.security.utils;

public class Validators {
    public static final String AT_SYMBOL = "@";

    public static boolean validateAddress(String serverAddress) {
        return serverAddress.contains(".");
    }

    public static boolean validateIDName(String idName) {
        if (idName.length() < 6) {
            return false;
        }
        if (Validators.containsMore(idName, AT_SYMBOL)) {
            return false;
        }
        return idName.contains(AT_SYMBOL);
    }

    public static boolean validateSubdomain(String subdomainName) {
        return !subdomainName.contains(".") && subdomainName.trim().length() > 1;
    }

    public static boolean validateDomain(String subdomainName) {
        if (subdomainName.contains(".")) {
            return !subdomainName.startsWith(".") && !subdomainName.endsWith(".");
        }
        return false;
    }

    private static boolean containsMore(String string, String subString) {
        int firstIndex = string.indexOf(subString);
        if (firstIndex == -1) {
            return false;
        }
        return firstIndex != string.lastIndexOf(subString);
    }
}

