/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.security.impl;

import com.jslope.framework.DNS;
import com.jslope.io.protocol.Address;
import com.jslope.io.protocol.errorhandling.ErrorHandler;
import com.jslope.io.protocol.errorhandling.impl.TextErrorHandler;
import com.jslope.io.stream.AdvancedDataInput;
import com.jslope.io.stream.AdvancedDataOutput;
import com.jslope.io.stream.StreamSerializable;
import com.jslope.io.stream.impl.AdvancedByteDataOutputStream;
import com.jslope.security.PublicDomain;
import com.jslope.security.PublicID;
import com.jslope.security.crypto.JSlopePublicKey;
import com.jslope.security.crypto.impl.CryptogException;
import com.jslope.security.crypto.impl.RSAPublicKey;
import com.jslope.security.crypto.utils.Utils;
import com.jslope.security.impl.AbstractSecureObject;
import com.jslope.security.impl.DomainVerifier;
import java.io.File;
import java.io.IOException;

public class JSlopePublicDomain
extends AbstractSecureObject
implements PublicDomain {
    private String domainName = "";
    private long signatureTime = 0L;
    private long expirationDate;
    private byte[] signature;
    private boolean isSigned = false;
    private boolean isRoot = false;
    private JSlopePublicKey publicKey;
    private JSlopePublicDomain parent;

    public JSlopePublicDomain() {
        this(new RSAPublicKey());
    }

    public JSlopePublicDomain(JSlopePublicKey publicKey) {
        this(publicKey, false);
    }

    public JSlopePublicDomain(JSlopePublicKey publicKey, boolean isRoot) {
        this.isRoot = isRoot;
        this.publicKey = publicKey;
    }

    @Override
    public void setSignature(byte[] signature, JSlopePublicDomain domain) {
        this.signature = signature;
        this.parent = domain;
        this.isSigned = true;
    }

    @Override
    public byte[] getSignature() {
        return this.signature;
    }

    @Override
    public void serialize(AdvancedDataOutput oos) throws IOException {
        this.bytesForSigning(oos);
        oos.writeBoolean(this.isSigned);
        oos.writeBoolean(this.isRoot);
        if (this.isSigned && !this.isRoot) {
            oos.writeBytes(this.signature);
            this.parent.serialize(oos);
        }
    }

    @Override
    public void deserialize(AdvancedDataInput bis) throws IOException {
        this.domainName = bis.readUTF();
        this.signatureTime = bis.readLong();
        this.publicKey.deserialize(bis);
        this.isSigned = bis.readBoolean();
        this.isRoot = bis.readBoolean();
        if (this.isSigned && !this.isRoot) {
            this.signature = bis.readBytes();
            this.parent = new JSlopePublicDomain();
            this.parent.deserialize(bis);
        }
    }

    @Override
    protected File defaultFile() {
        return new File(this.getName() + ".publicdomain");
    }

    @Override
    public String getName() {
        return this.domainName;
    }

    @Override
    public boolean verifyInternalSignature() throws CryptogException {
        if (this.isRoot) {
            return DomainVerifier.verifyRootDomain(this);
        }
        if (this.isSigned) {
            if (this.parent.publicKey.isValid(this.getData(), this.signature)) {
                return this.parent.verifyInternalSignature();
            }
            return false;
        }
        return false;
    }

    @Override
    public byte[] getData() {
        AdvancedByteDataOutputStream dos = new AdvancedByteDataOutputStream();
        try {
            this.bytesForSigning(dos);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return dos.toByteArray();
    }

    @Override
    public boolean isEqual(PublicDomain publicDomain) {
        JSlopePublicDomain domain = (JSlopePublicDomain)publicDomain;
        if (Utils.compareBytes(this.getData(), publicDomain.getData())) {
            if (this.isRoot) {
                return true;
            }
            return this.parent.isEqual(domain.getParent());
        }
        return false;
    }

    @Override
    public String getParentDomainName() {
        int pos = this.getName().indexOf(46);
        return this.getName().substring(pos + 1);
    }

    @Override
    public byte[] getKeyData() {
        return this.publicKey.getEncoded();
    }

    @Override
    public boolean isSigned() {
        return this.isSigned;
    }

    @Override
    public void updateSignTime() {
        this.signatureTime = System.currentTimeMillis();
    }

    @Override
    public PublicDomain getParent() {
        return this.parent;
    }

    @Override
    public long getSignTime() {
        return this.signatureTime;
    }

    private void bytesForSigning(AdvancedDataOutput dos) throws IOException {
        dos.writeUTF(this.domainName);
        dos.writeLong(this.signatureTime);
        System.out.println("domain name: " + this.domainName + " signatureTime: " + this.signatureTime);
        this.publicKey.serialize(dos);
    }

    public void setName(String name) {
        this.domainName = name;
    }

    public static PublicDomain loadNewFromFile(File domainFile) throws IOException {
        JSlopePublicDomain publicDomain = new JSlopePublicDomain();
        publicDomain.loadFromFile(domainFile);
        return publicDomain;
    }

    @Override
    public boolean isRoot() {
        return this.isRoot;
    }

    public JSlopePublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public boolean verifySignature(byte[] message, byte[] signature) throws CryptogException {
        return this.publicKey.isValid(message, signature);
    }

    @Override
    public boolean verifySignature(StreamSerializable signedObject, byte[] signature) throws CryptogException {
        AdvancedByteDataOutputStream out = new AdvancedByteDataOutputStream();
        try {
            signedObject.serialize(out);
            byte[] signedBytes = out.toByteArray();
            return this.verifySignature(signedBytes, signature);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to serialize object: " + signedObject);
        }
    }

    public boolean verifyExternalIDSignature(PublicID id, byte[] signature) throws CryptogException {
        return this.verifySignature(id, signature);
    }

    @Override
    public Address getHostAddress() {
        TextErrorHandler errorHandler = new TextErrorHandler();
        return this.getHostAddress(errorHandler);
    }

    public Address getHostAddress(ErrorHandler errorHandler) {
        return DNS.getAddress(this.getName(), errorHandler);
    }

    public String toString() {
        return this.getName();
    }
}

