/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.security.impl;

import com.jslope.security.PublicDomain;
import com.jslope.security.PublicID;
import com.jslope.security.crypto.impl.CryptogException;
import com.jslope.security.impl.JSlopePublicDomain;
import com.jslope.security.impl.RootDomains;

public class DomainVerifier {
    public static boolean verifyDomain(PublicDomain domain) throws CryptogException {
        return domain.verifyInternalSignature();
    }

    public static boolean verifyRootDomain(JSlopePublicDomain domain) throws CryptogException {
        if (!domain.isRoot()) {
            return false;
        }
        if (RootDomains.getRootPublicDomain(domain.getName()).isEqual(domain)) {
            return true;
        }
        throw new CryptogException("Root domains aren't the same for domain: " + domain);
    }

    public static boolean verifyID(PublicID publicID) throws CryptogException {
        return publicID.verifyInternalSignature();
    }
}

