/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.security.impl;

import com.jslope.io.stream.AdvancedDataInput;
import com.jslope.io.stream.AdvancedDataOutput;
import com.jslope.io.stream.StreamSerializable;
import com.jslope.io.stream.impl.AdvancedByteDataInputStream;
import com.jslope.io.stream.impl.AdvancedByteDataOutputStream;
import com.jslope.io.utils.IOUtils;
import com.jslope.security.SecureObject;
import com.jslope.security.crypto.utils.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public abstract class AbstractSecureObject
implements StreamSerializable,
SecureObject {
    @Override
    public abstract void serialize(AdvancedDataOutput var1) throws IOException;

    @Override
    public abstract void deserialize(AdvancedDataInput var1) throws IOException;

    @Override
    public byte[] toBytes() {
        AdvancedByteDataOutputStream dos = new AdvancedByteDataOutputStream();
        try {
            this.serialize(dos);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return dos.toByteArray();
    }

    @Override
    public void saveToFile(File secureObjectFile) throws IOException {
        try {
            if (secureObjectFile.exists()) {
                secureObjectFile.delete();
            }
            FileOutputStream fos = new FileOutputStream(secureObjectFile);
            fos.write(this.toBytes());
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new IOException("Unable to create file for writting " + secureObjectFile);
        }
    }

    @Override
    public void saveToDirectory(File directory) throws IOException {
        directory.mkdirs();
        File objectFile = new File(directory.getPath() + File.separator + this.defaultFile().getName());
        System.out.println("Saving to directory: " + objectFile.getName());
        this.saveToFile(objectFile);
    }

    @Override
    public void loadFromFile(File domainFile) throws IOException {
        byte[] bytes = IOUtils.loadFile(domainFile);
        this.load(bytes);
    }

    protected abstract File defaultFile();

    @Override
    public void saveToFile() throws IOException {
        this.saveToFile(this.defaultFile());
    }

    @Override
    public void loadFromFile() throws IOException {
        this.loadFromFile(this.defaultFile());
    }

    public void load(byte[] publicDomainBytes) {
        AdvancedByteDataInputStream bis = new AdvancedByteDataInputStream(publicDomainBytes);
        try {
            this.deserialize(bis);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isEqual(SecureObject obj) {
        return Utils.compareBytes(this.toBytes(), obj.toBytes());
    }

    public boolean equals(Object obj) {
        throw new RuntimeException("It's not alowed to use equals on secure objects, please use isEqual instead");
    }
}

