/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.security.impl;

import com.jslope.io.stream.AdvancedDataInput;
import com.jslope.io.stream.AdvancedDataOutput;
import com.jslope.io.stream.StreamSerializable;
import com.jslope.security.Domain;
import com.jslope.security.ObjectSignedByDomain;
import com.jslope.security.PublicDomain;
import com.jslope.security.crypto.impl.CryptogException;
import com.jslope.security.impl.DomainFactory;
import java.io.IOException;

public abstract class AbstractObjectSignedByDomain
implements ObjectSignedByDomain,
StreamSerializable {
    protected StreamSerializable signedObject;
    protected PublicDomain publicDomain;
    byte[] signature;

    protected void sign(Domain domain) throws CryptogException {
        this.signature = domain.sign(this.signedObject);
    }

    @Override
    public boolean verifySignature() throws CryptogException {
        return this.publicDomain.verifyInternalSignature() && this.publicDomain.verifySignature(this.signedObject, this.signature);
    }

    @Override
    public PublicDomain getDomain() {
        return this.publicDomain;
    }

    @Override
    public void serialize(AdvancedDataOutput os) throws IOException {
        this.signedObject.serialize(os);
        this.publicDomain.serialize(os);
        os.writeBytes(this.signature);
    }

    @Override
    public void deserialize(AdvancedDataInput is) throws IOException {
        this.signedObject = this.newSignedObject();
        this.signedObject.deserialize(is);
        this.publicDomain = DomainFactory.deserializePublicDomain(is);
        this.signature = is.readBytes();
    }

    public abstract StreamSerializable newSignedObject();
}

