/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.persistence.validators;

import com.jslope.persistence.fields.Field;
import com.jslope.persistence.validators.Validator;

public class SizeValidator
implements Validator {
    private int minSize = 0;
    private int maxSize = 0;
    private String errorMessage;

    public SizeValidator(int minSize, int maxSize) {
        this.minSize = minSize;
        this.maxSize = maxSize;
    }

    @Override
    public boolean validate(Field f) {
        String value = f.getValue();
        if (value == null) {
            return true;
        }
        int length = value.length();
        if (this.minSize > 0 && length < this.minSize) {
            this.errorMessage = "Minimum size is " + this.minSize;
            return false;
        }
        if (this.maxSize > 0 && length > this.maxSize) {
            this.errorMessage = "Maximum size is " + this.maxSize;
            return false;
        }
        return true;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }
}

