/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.persistence.sql;

import com.jslope.persistence.DBConnection;
import com.jslope.persistence.sql.DefaultSqlServer;

public class HSqlDbServer
extends DefaultSqlServer {
    @Override
    public String formatTableName(String tableName) {
        return tableName;
    }

    @Override
    public String formatField(String fieldName) {
        return fieldName;
    }

    @Override
    public void createTable(String tableName) {
        String sql = "CREATE TABLE " + this.formatTableName(tableName) + " (isDeleted VARCHAR(1) DEFAULT '' NOT NULL)";
        HSqlDbServer.executeUpdate(sql);
    }

    @Override
    public String formatValue(String fieldName) {
        return this.surround(fieldName, '\'');
    }

    @Override
    public void addField(String tableName, String fieldName, String fieldType) {
        String sql = "ALTER TABLE " + tableName + " ADD COLUMN " + this.formatField(fieldName) + " " + fieldType + "";
        HSqlDbServer.executeUpdate(sql);
    }

    @Override
    public String getTypeForNumber(int decimalSize, int floatSize) {
        return "DECIMAL(" + decimalSize + ", " + floatSize + ")";
    }

    @Override
    public String getTypeForDate() {
        return "DATETIME";
    }

    @Override
    public void close() {
        HSqlDbServer.executeUpdate("SHUTDOWN COMPACT");
        DBConnection.closeConnection();
    }

    @Override
    public String getTypeForBlob() {
        return "LONGVARBINARY";
    }
}

