/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.persistence.fields;

import com.jslope.persistence.fields.Field;
import com.jslope.persistence.fields.interfaces.DateContainer;
import com.jslope.persistence.sql.SqlUtil;
import java.util.Date;

public class DateField
extends Field
implements DateContainer {
    protected Date date;

    public DateField() {
        this.date = new Date();
    }

    public DateField(Date date) {
        this.date = date;
        this.setDefaultValue(DateField.dateValue(date));
    }

    @Override
    public void setValue(String s) {
        this.date = SqlUtil.getSqlServer().parseDate(s);
    }

    @Override
    public String getValue() {
        return DateField.dateValue(this.date);
    }

    @Override
    public String getSQLType() {
        return SqlUtil.getSqlServer().getTypeForDate();
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public void setDate(Date newDate) {
        this.date = newDate;
    }

    public static String dateValue(Date date) {
        return SqlUtil.getSqlServer().dateToString(date);
    }
}

