/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.persistence;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Config {
    private static Properties properties;
    private static Config instance;

    private Config() {
        properties = new Properties();
        InputStream stream = null;
        try {
            stream = Config.class.getClassLoader().getResourceAsStream("persistence.cfg");
            properties.load(stream);
            stream.close();
        }
        catch (IOException e) {
            System.out.println("unable to load properties (IOException)");
            System.exit(1);
        }
        catch (NullPointerException e) {
            System.out.println("unable to load properties (NullPointerException)");
            System.exit(1);
        }
    }

    public static String getDBUrl() {
        return (String)Config.getConfig().getProperties().get("DB_URL");
    }

    public static String getDBDriverClass() {
        return (String)Config.getConfig().getProperties().get("DRIVER_CLASS");
    }

    public static String getPanelsPackage() {
        return (String)Config.getConfig().getProperties().get("PANELS_PACKAGE");
    }

    public static String getMainPanel() {
        return (String)Config.getConfig().getProperties().get("MAIN_PANEL");
    }

    public static String getDBUsername() {
        return (String)Config.getConfig().getProperties().get("USERNAME");
    }

    public static String getDBPassword() {
        return (String)Config.getConfig().getProperties().get("PASSWORD");
    }

    public static String getFieldsTableName() {
        return (String)Config.getConfig().getProperties().get("FIELDS_TABLE_NAME");
    }

    public static String getTypesTableName() {
        return (String)Config.getConfig().getProperties().get("TYPES_FIELD_NAME");
    }

    public static String getTemplateRoot() {
        return (String)Config.getConfig().getProperties().get("TEMPLATE_ROOT");
    }

    public static boolean isLive() {
        String value = (String)Config.getConfig().getProperties().get("IS_LIVE");
        if (value == null) {
            return true;
        }
        return "Y".equals(value = value.toUpperCase()) || "TRUE".equals(value) || "YES".equals(value);
    }

    public static String getSqlServerHandler() {
        return (String)Config.getConfig().getProperties().get("SQL_SERVER");
    }

    public Properties getProperties() {
        return properties;
    }

    public static Config getConfig() {
        if (instance == null) {
            instance = new Config();
            return instance;
        }
        return instance;
    }

    static {
        instance = null;
    }
}

