/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.io.utils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class BlockingMap<A, B> {
    private final ConcurrentMap<A, BlockingObject<B>> map = new ConcurrentHashMap<A, BlockingObject<B>>();
    private final Lock lock = new ReentrantLock();
    private final Map<Thread, BlockingObject> blockedThreadsMap = new ConcurrentHashMap<Thread, BlockingObject>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public B put(A key, B object) {
        BlockingObject blockingObj = (BlockingObject)this.map.get(key);
        this.lock.lock();
        try {
            if (blockingObj == null) {
                this.map.putIfAbsent(key, new BlockingObject());
                blockingObj = (BlockingObject)this.map.get(key);
            }
        }
        finally {
            this.lock.unlock();
        }
        blockingObj.set(object);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public B take(A key) throws InterruptedException {
        BlockingObject blockingObj = (BlockingObject)this.map.get(key);
        this.lock.lock();
        try {
            if (blockingObj == null) {
                this.map.putIfAbsent(key, new BlockingObject());
                blockingObj = (BlockingObject)this.map.get(key);
            }
        }
        finally {
            this.lock.unlock();
        }
        this.blockedThreadsMap.put(Thread.currentThread(), blockingObj);
        Object result = blockingObj.get();
        this.blockedThreadsMap.remove(Thread.currentThread());
        this.lock.lock();
        try {
            this.map.remove(key);
        }
        finally {
            this.lock.unlock();
        }
        return (B)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.lock.lock();
        try {
            for (Thread thread : this.blockedThreadsMap.keySet()) {
                thread.interrupt();
            }
            this.map.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    class BlockingObject<C> {
        private volatile C object = null;
        private final CountDownLatch latch = new CountDownLatch(1);
        private final Lock lock = new ReentrantLock();

        BlockingObject() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isAvailable() {
            this.lock.lock();
            try {
                boolean bl = this.latch.getCount() == 0L;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(C object) {
            this.lock.lock();
            try {
                if (!this.isAvailable()) {
                    this.object = object;
                    this.latch.countDown();
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        public C get() throws InterruptedException {
            this.latch.await();
            return this.object;
        }
    }
}

