/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.io.server;

import com.jslope.framework.DomainManager;
import com.jslope.io.protocol.Address;
import com.jslope.io.protocol.errorhandling.ErrorHandler;
import com.jslope.io.server.ServerConfiguration;
import com.jslope.io.stream.AdvancedDataInput;
import com.jslope.io.stream.AdvancedDataOutput;
import com.jslope.io.stream.StreamSerializable;
import com.jslope.io.stream.impl.AdvancedIODataInputStream;
import com.jslope.io.stream.impl.AdvancedIODataOutputStream;
import com.jslope.security.Domain;
import com.jslope.security.IDSignedByDomain;
import com.jslope.security.PublicID;
import com.jslope.security.SecureID;
import com.jslope.security.crypto.impl.CryptogException;
import com.jslope.security.impl.IDFactory;
import com.jslope.security.impl.JSlopeIDSignedByDomain;
import com.jslope.security.impl.SignFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class DefaultServerConfiguration
implements ServerConfiguration,
StreamSerializable {
    SecureID serverID;
    PublicID rootID;
    IDSignedByDomain idSignedByDomain;
    public static final String CONFIG_FILE_NAME = "server.config";

    public DefaultServerConfiguration(Domain domain, String serverAddress, SecureID serverID, PublicID rootID, ErrorHandler errorHandler) throws CryptogException {
        Address newServerAddress = new Address(serverAddress);
        if (!domain.getPublicPart().isRoot()) {
            DomainManager.updateDNSForDomain(domain, newServerAddress, errorHandler);
        }
        this.serverID = serverID;
        this.rootID = rootID;
        this.idSignedByDomain = new JSlopeIDSignedByDomain(serverID.getPublicPart(), domain);
    }

    public DefaultServerConfiguration() {
    }

    @Override
    public void save(File directoryToSaveTo) throws IOException {
        String fullFileName = directoryToSaveTo + File.separator + CONFIG_FILE_NAME;
        System.out.println("Now will save to this file name: " + fullFileName);
        File fileName = new File(fullFileName);
        FileOutputStream fileWriter = new FileOutputStream(fileName, false);
        AdvancedIODataOutputStream out = new AdvancedIODataOutputStream(fileWriter);
        this.serialize(out);
        out.flush();
        fileWriter.close();
    }

    @Override
    public void load() throws IOException {
        File configFile = new File(CONFIG_FILE_NAME);
        if (configFile.exists()) {
            FileInputStream fi = new FileInputStream(configFile);
            AdvancedIODataInputStream in = new AdvancedIODataInputStream(fi);
            this.deserialize(in);
        } else {
            System.out.println("Config file does not exist");
            System.exit(1);
        }
    }

    @Override
    public void verifyData() throws CryptogException {
        if (!this.serverID.getPublicPart().verifyInternalSignature()) {
            throw new CryptogException("Bad signature for Server ID" + this.serverID.getName());
        }
        if (!this.rootID.verifyInternalSignature()) {
            throw new CryptogException("Bad signature for Root ID" + this.rootID.getName());
        }
        if (!this.idSignedByDomain.verifySignature()) {
            throw new CryptogException("Bad signature for Domain signed by ID" + this.idSignedByDomain.getName());
        }
    }

    @Override
    public SecureID getServerID() {
        return this.serverID;
    }

    @Override
    public Iterable<? extends IDSignedByDomain> getDomains() {
        ArrayList<IDSignedByDomain> list = new ArrayList<IDSignedByDomain>();
        list.add(this.idSignedByDomain);
        return list;
    }

    @Override
    public void serialize(AdvancedDataOutput os) throws IOException {
        this.serverID.serialize(os);
        this.rootID.serialize(os);
        this.idSignedByDomain.serialize(os);
    }

    @Override
    public void deserialize(AdvancedDataInput is) throws IOException {
        this.serverID = IDFactory.deserializeSecureID(is);
        this.rootID = IDFactory.deserializePublicID(is);
        this.idSignedByDomain = SignFactory.deserializeIDSignedByDomain(is);
    }
}

