/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.io.protocol.messages;

import com.jslope.io.protocol.messages.AbstractSignedMessage;
import com.jslope.io.protocol.messages.MailMessage;
import com.jslope.io.stream.AdvancedDataInput;
import com.jslope.io.stream.AdvancedDataOutput;
import com.jslope.security.PublicID;
import com.jslope.security.crypto.EncryptedBytes;
import com.jslope.security.crypto.impl.CryptogException;
import com.jslope.security.crypto.impl.JSlopeEncryptedBytes;
import com.jslope.security.impl.IDFactory;
import java.io.IOException;

public class DefaultMailMessage
extends AbstractSignedMessage
implements MailMessage {
    PublicID destination;
    PublicID source;
    EncryptedBytes encryptedData;
    boolean isBounced = false;

    public DefaultMailMessage() {
    }

    public DefaultMailMessage(PublicID destinationID, PublicID sourceID, EncryptedBytes encrypted) {
        this.destination = destinationID;
        this.source = sourceID;
        this.encryptedData = encrypted;
    }

    @Override
    public String getString() {
        return "Encrypted message from " + this.source.getName() + " to " + this.destination.getName();
    }

    public String toString() {
        return this.getString();
    }

    @Override
    protected void serializeUnsigned(AdvancedDataOutput dos) throws IOException {
        this.destination.serialize(dos);
        this.source.serialize(dos);
        this.encryptedData.serialize(dos);
        dos.writeBoolean(this.isBounced);
    }

    @Override
    protected void deserializeUnsigned(AdvancedDataInput is) throws IOException {
        this.destination = IDFactory.deserializePublicID(is);
        this.source = IDFactory.deserializePublicID(is);
        this.encryptedData = JSlopeEncryptedBytes.deserializeNew(is);
        this.isBounced = is.readBoolean();
    }

    @Override
    public void verifySignature() throws CryptogException {
        if (!this.source.verifySignature(this.getUnsignedBytes(), this.signature)) {
            throw new CryptogException("Bad signature");
        }
    }

    @Override
    public PublicID getDestinationID() {
        return this.destination;
    }

    @Override
    public PublicID getSourceID() {
        return this.source;
    }

    @Override
    public EncryptedBytes getEncryptedBytes() {
        return this.encryptedData;
    }

    @Override
    public boolean isBounced() {
        return this.isBounced;
    }

    @Override
    public void setIsBounced(boolean newValue) {
        this.isBounced = newValue;
    }
}

