/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.io.protocol.impl.client2client;

import com.jslope.io.protocol.Address;
import com.jslope.io.protocol.errorhandling.ErrorHandler;
import com.jslope.io.protocol.impl.IODataTransport;
import com.jslope.io.protocol.impl.TransportFactory;
import com.jslope.io.protocol.impl.client2client.C2CClientProtocol;
import com.jslope.io.protocol.impl.client2client.C2CServerProtocol;
import com.jslope.io.protocol.impl.client2client.Client2ClientClientAction;
import com.jslope.io.protocol.impl.client2client.Client2ClientServerAction;
import com.jslope.io.stream.DataTransport;
import com.jslope.security.PublicID;
import com.jslope.security.SecureID;
import com.jslope.security.crypto.JSlopeSymetricKey;
import com.jslope.security.crypto.SymetricKeyFactory;
import com.jslope.security.crypto.impl.CryptogException;
import com.jslope.security.crypto.utils.JSlopeRandom;
import java.io.IOException;
import java.net.Socket;

public class C2CProtocol
implements C2CServerProtocol,
C2CClientProtocol {
    private SecureID localID;
    private PublicID remoteID;
    private String remoteIDName;
    DataTransport tr;
    ErrorHandler errorHandler;

    public C2CProtocol(SecureID secureID, String connectToIDName, ErrorHandler eh) {
        this.localID = secureID;
        this.remoteIDName = connectToIDName;
        this.errorHandler = eh;
    }

    public void startServer(Socket socket, Client2ClientServerAction serverAction) throws IOException, CryptogException {
        this.tr = new IODataTransport(socket);
        this.tr.writePublicID(this.localID.getPublicPart());
        byte[] encryptedKey = this.tr.readBytes();
        byte[] decryptedKey = this.localID.decryptLowLevelBytes(encryptedKey);
        JSlopeSymetricKey simmetrycKey = SymetricKeyFactory.createKey(decryptedKey);
        this.tr = TransportFactory.generate(this.tr, simmetrycKey);
        this.remoteID = this.tr.readPublicID();
        if (this.remoteID.getName().equals(this.remoteIDName)) {
            byte[] randomBytes = JSlopeRandom.getRandom(1024);
            this.tr.writeBytes(randomBytes);
            System.out.println("wrote verification...");
            byte[] signature = this.tr.readBytes();
            boolean signatureIsOk = this.remoteID.verifySignature(randomBytes, signature);
            if (signatureIsOk) {
                System.out.println("Client signature is ok");
                serverAction.doServerAction(this);
            } else {
                this.errorHandler.addError("Bad remoteID", "Bad remoteID, signature test wasn't passed");
            }
        } else {
            this.errorHandler.addError("Bad remote ID name", "Remote ID is " + this.remoteID.getName() + " but required " + this.remoteIDName + " possible man in the middle attack ");
        }
        this.tr.close();
    }

    public void startClient(Address address, Client2ClientClientAction clientAction) {
        try {
            Socket socket = address.connect();
            this.tr = new IODataTransport(socket);
            this.remoteID = this.tr.readPublicID();
            if (this.remoteID.getName().equals(this.remoteIDName)) {
                JSlopeSymetricKey simmetrycKey = SymetricKeyFactory.generateKey();
                byte[] encryptedKey = this.remoteID.encryptLowLevelBytes(simmetrycKey.getBytes());
                this.tr.writeBytes(encryptedKey);
                this.tr = TransportFactory.generate(this.tr, simmetrycKey);
                this.tr.writePublicID(this.localID.getPublicPart());
                byte[] bytesToSign = this.tr.readBytes();
                System.out.println("read bytes to sign...");
                byte[] signature = this.localID.signLowLevelBytes(bytesToSign);
                this.tr.writeBytes(signature);
                clientAction.doClientAction(this);
            } else {
                this.errorHandler.addError("Bad remote ID name", "Remote ID is " + this.remoteID.getName() + " but required " + this.remoteIDName + " possible man in the middle attack ");
            }
            this.tr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.errorHandler.addError(e);
        }
        catch (CryptogException e) {
            e.printStackTrace();
            this.errorHandler.addError(e);
        }
    }

    @Override
    public DataTransport getTransport() {
        return this.tr;
    }
}

