/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.io.protocol.impl.actions;

import com.jslope.io.protocol.Address;
import com.jslope.io.protocol.ClientProtocol;
import com.jslope.io.protocol.ProtocolConstants;
import com.jslope.io.protocol.ServerHandler;
import com.jslope.io.protocol.ServerProtocol;
import com.jslope.io.protocol.exceptions.ActionException;
import com.jslope.io.protocol.impl.actions.ProtocolAction;
import com.jslope.io.stream.DataTransport;
import com.jslope.security.AddressSignedByDomain;
import com.jslope.security.Domain;
import com.jslope.security.crypto.impl.CryptogException;
import com.jslope.security.impl.SignFactory;
import java.io.IOException;

public class UpdateDNSAction
implements ProtocolAction {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doServerSide(ServerProtocol parentProtocol) throws IOException, ActionException {
        ServerHandler serverHandler = parentProtocol.getServerHandler();
        DataTransport tr = parentProtocol.getTransport();
        AddressSignedByDomain signedAddress = SignFactory.deserializeAddressSignedByDomain(tr);
        try {
            if (!serverHandler.domainExists(signedAddress.getDomain().getParent())) {
                tr.writeByte((byte)10);
                throw new ActionException("Domain for which subdomain update was intendent doesn't exist on this server");
            }
            if (!signedAddress.verifySignature()) {
                tr.writeByte((byte)6);
                parentProtocol.addError("Signature verification error", "Signature verification error from " + parentProtocol.getConnectedToIP());
                tr.writeByte((byte)6);
                throw new ActionException("Cryptographic error");
            }
            if (serverHandler.updateAddress(signedAddress)) {
                tr.writeByte((byte)1);
                return;
            }
            tr.writeByte((byte)11);
            throw new ActionException("Update of new domain address failed");
        }
        catch (CryptogException e) {
            e.printStackTrace();
            parentProtocol.addError(e);
            tr.writeByte((byte)6);
            throw new ActionException("Cryptographic error", e);
        }
    }

    @Override
    public void doClientSide(ClientProtocol parentProtocol) throws IOException, ActionException {
        try {
            DataTransport tr = parentProtocol.getTransport();
            Domain domain = (Domain)parentProtocol.getValue(ProtocolConstants.DOMAIN);
            Address newAddress = (Address)parentProtocol.getValue(ProtocolConstants.NEW_DOMAIN_ADDRESS);
            AddressSignedByDomain signedAddress = SignFactory.signObject(newAddress, domain);
            signedAddress.serialize(tr);
            switch (tr.readByte()) {
                case 1: {
                    break;
                }
                case 6: {
                    parentProtocol.addError("Cryptographic error on server", "Cryptographic error on server");
                    throw new ActionException("Cryptographic error on server");
                }
                case 10: {
                    parentProtocol.addError("Domain not exists on server", "Domain not exists on server");
                    throw new ActionException("Domain not exists on server");
                }
            }
        }
        catch (CryptogException e) {
            e.printStackTrace();
            parentProtocol.addError(e);
            throw new ActionException("CryptogException occured", e);
        }
    }
}

