/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.io.protocol.impl.actions;

import com.jslope.io.protocol.ClientProtocol;
import com.jslope.io.protocol.ProtocolConstants;
import com.jslope.io.protocol.ServerProtocol;
import com.jslope.io.protocol.exceptions.ActionException;
import com.jslope.io.protocol.impl.actions.ProtocolAction;
import com.jslope.io.stream.DataTransport;
import com.jslope.security.PublicID;
import com.jslope.security.impl.IDFactory;
import java.io.IOException;

public class SendUnsignedIDAction
implements ProtocolAction {
    @Override
    public void doServerSide(ServerProtocol parentProtocol) throws IOException {
        DataTransport tr = parentProtocol.getTransport();
        PublicID unsignedID = IDFactory.deserializePublicID(tr);
        parentProtocol.setValue(ProtocolConstants.UNSIGNED_ID, unsignedID);
    }

    @Override
    public void doClientSide(ClientProtocol parentProtocol) throws IOException, ActionException {
        DataTransport tr = parentProtocol.getTransport();
        PublicID unsignedID = (PublicID)parentProtocol.getValue(ProtocolConstants.UNSIGNED_ID);
        unsignedID.serialize(tr);
    }
}

