/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.io.protocol.impl.actions;

import com.jslope.io.protocol.ClientProtocol;
import com.jslope.io.protocol.ProtocolConstants;
import com.jslope.io.protocol.ServerHandler;
import com.jslope.io.protocol.ServerProtocol;
import com.jslope.io.protocol.exceptions.ActionException;
import com.jslope.io.protocol.impl.actions.ProtocolAction;
import com.jslope.io.protocol.messages.StringMessage;
import com.jslope.io.stream.DataTransport;
import com.jslope.security.Domain;
import com.jslope.security.PublicDomain;
import com.jslope.security.crypto.impl.CryptogException;
import java.io.IOException;

public class RemoveIDPermitAction
implements ProtocolAction {
    @Override
    public void doServerSide(ServerProtocol parentProtocol) throws IOException, ActionException, CryptogException {
        ServerHandler serverHandler = parentProtocol.getServerHandler();
        DataTransport tr = parentProtocol.getTransport();
        PublicDomain publicDomain = parentProtocol.getConnectedDomain();
        StringMessage message = new StringMessage();
        message.deserialize(tr);
        String idName = message.getString();
        byte[] signature = tr.readBytes();
        if (publicDomain.isEqual(serverHandler.getDomainByID(idName)) && publicDomain.verifySignature(message, signature)) {
            serverHandler.removeIDPermit(idName);
            tr.writeByte((byte)1);
        } else {
            tr.writeByte((byte)2);
        }
    }

    @Override
    public void doClientSide(ClientProtocol parentProtocol) throws IOException, ActionException, CryptogException {
        DataTransport tr = parentProtocol.getTransport();
        Domain domain = (Domain)parentProtocol.getValue(ProtocolConstants.DOMAIN_TO_CONNECT);
        String idName = (String)parentProtocol.getValue(ProtocolConstants.ID_NAME);
        StringMessage message = new StringMessage(idName);
        byte[] signature = domain.sign(message);
        message.serialize(tr);
        tr.writeBytes(signature);
        Boolean retVal = tr.readByte() == 1;
        parentProtocol.setValue(ProtocolConstants.BOOLEAN_RESULT, retVal);
    }
}

