/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.io.protocol.impl.actions;

import com.jslope.io.protocol.ClientHandler;
import com.jslope.io.protocol.ClientProtocol;
import com.jslope.io.protocol.ProtocolConstants;
import com.jslope.io.protocol.ServerEvent;
import com.jslope.io.protocol.ServerHandler;
import com.jslope.io.protocol.ServerProtocol;
import com.jslope.io.protocol.exceptions.ActionException;
import com.jslope.io.protocol.impl.actions.ProtocolAction;
import com.jslope.io.stream.DataTransport;
import com.jslope.logger.Log;
import com.jslope.security.PublicID;
import com.jslope.security.SecureID;
import com.jslope.security.crypto.impl.CryptogException;
import com.jslope.security.crypto.utils.JSlopeRandom;
import com.jslope.security.crypto.utils.Utils;
import java.io.IOException;

public class ListenClientToServerAction
implements ProtocolAction {
    private static final byte WAITING_FOR_MORE_ACTIONS = 43;
    private static final byte END = 19;

    @Override
    public void doServerSide(ServerProtocol parentProtocol) throws IOException, ActionException, CryptogException {
        DataTransport tr = parentProtocol.getTransport();
        ServerHandler serverHandler = parentProtocol.getServerHandler();
        String unsignedIDName = tr.readUTF();
        Log.debug("In ListenClientToServerAction received request for notification for id: " + unsignedIDName);
        PublicID unsignedID = serverHandler.getUnsignedID(unsignedIDName);
        boolean IDIsSigned = false;
        if (unsignedID == null) {
            Log.debug("In ListenClientToServerAction unsigned id is null for id: " + unsignedIDName + " this means that there must be a signed id on server");
            unsignedID = serverHandler.getInstalledID(unsignedIDName);
            IDIsSigned = true;
            if (unsignedID == null) {
                Log.debug("ERROR: unsignedID is still null ");
            }
        } else {
            Log.debug("In ListenClientToServerAction unsigned id is not null for id: " + unsignedIDName + " this means that id is still not signed here");
        }
        byte[] randomBytes = JSlopeRandom.getRandom(80);
        byte[] encriptedBytes = unsignedID.encryptLowLevelBytes(randomBytes);
        Log.debug("Encrypted bytes for checking autenticity for " + unsignedIDName);
        tr.writeBytes(encriptedBytes);
        byte[] decryptedBytes = tr.readBytes();
        if (Utils.compareBytes(randomBytes, decryptedBytes)) {
            Log.debug("Autentification succesful for " + unsignedIDName);
            tr.writeByte((byte)1);
            while (tr.readByte() == 43) {
                ServerEvent event = IDIsSigned ? new ServerEvent() : serverHandler.getNextEventForClient(unsignedIDName);
                event.writeServerEvent(tr);
            }
        } else {
            tr.writeByte((byte)2);
        }
    }

    @Override
    public void doClientSide(ClientProtocol parentProtocol) throws IOException, ActionException, CryptogException {
        DataTransport tr = parentProtocol.getTransport();
        SecureID unsignedID = (SecureID)parentProtocol.getValue(ProtocolConstants.UNSIGNED_ID);
        String idName = unsignedID.getName();
        Log.debug("In ListenClientToServerAction waiting for notification for id: " + idName);
        tr.writeUTF(idName);
        byte[] encryptedBytes = tr.readBytes();
        byte[] decryptedBytes = unsignedID.decryptLowLevelBytes(encryptedBytes);
        tr.writeBytes(decryptedBytes);
        Log.debug("Autentication data sent for id: " + idName);
        byte authResult = tr.readByte();
        if (authResult == 1) {
            Log.debug("Autentication sucessful with id: " + idName);
            ClientHandler clientHandler = (ClientHandler)parentProtocol.getValue(ProtocolConstants.CLIENT_HANDLER);
            do {
                tr.writeByte((byte)43);
                Log.debug("Now we'll wait for an event for id: " + idName);
                ServerEvent event = ServerEvent.readNewEvent(tr);
                Log.debug("Event received for id: " + idName);
                clientHandler.processListenToClientServerEvent(idName, event);
            } while (clientHandler.areThereMoreActionsToWaitForClient(idName));
            tr.writeByte((byte)19);
        } else {
            parentProtocol.addError("Authentication failed on server", "Authentication for " + unsignedID.getName() + " failed on server ");
        }
    }
}

