/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.io.protocol.impl.actions;

import com.jslope.io.protocol.ClientProtocol;
import com.jslope.io.protocol.ProtocolConstants;
import com.jslope.io.protocol.ServerHandler;
import com.jslope.io.protocol.ServerProtocol;
import com.jslope.io.protocol.exceptions.ActionException;
import com.jslope.io.protocol.impl.actions.ProtocolAction;
import com.jslope.io.stream.DataTransport;
import com.jslope.security.PublicID;
import com.jslope.security.crypto.impl.CryptogException;
import com.jslope.security.impl.IDFactory;
import java.io.IOException;

public class InstallIDonServerAction
implements ProtocolAction {
    @Override
    public void doServerSide(ServerProtocol parentProtocol) throws IOException, ActionException, CryptogException {
        DataTransport tr = parentProtocol.getTransport();
        ServerHandler serverHandler = parentProtocol.getServerHandler();
        PublicID publicID = IDFactory.deserializePublicID(tr);
        if (publicID.verifyInternalSignature()) {
            serverHandler.createAccountOnServer(publicID);
            tr.writeByte((byte)1);
        } else {
            tr.writeByte((byte)7);
        }
    }

    @Override
    public void doClientSide(ClientProtocol parentProtocol) throws IOException, ActionException, CryptogException {
        DataTransport tr = parentProtocol.getTransport();
        PublicID publicID = (PublicID)parentProtocol.getValue(ProtocolConstants.PUBLIC_ID);
        publicID.serialize(tr);
        Boolean retVal = tr.readByte() == 1;
        parentProtocol.setValue(ProtocolConstants.BOOLEAN_RESULT, retVal);
    }
}

