/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.io.protocol.impl.actions;

import com.jslope.io.protocol.ClientProtocol;
import com.jslope.io.protocol.ProtocolConstants;
import com.jslope.io.protocol.ServerHandler;
import com.jslope.io.protocol.ServerProtocol;
import com.jslope.io.protocol.exceptions.ActionException;
import com.jslope.io.protocol.impl.actions.ProtocolAction;
import com.jslope.io.stream.DataTransport;
import com.jslope.security.Domain;
import com.jslope.security.crypto.impl.CryptogException;
import com.jslope.security.impl.JSlopeIDPermit;
import java.io.IOException;

public class InstallIDPermitAction
implements ProtocolAction {
    @Override
    public void doServerSide(ServerProtocol parentProtocol) throws IOException, ActionException, CryptogException {
        DataTransport tr = parentProtocol.getTransport();
        ServerHandler serverHandler = parentProtocol.getServerHandler();
        JSlopeIDPermit idPermit = new JSlopeIDPermit();
        idPermit.deserialize(tr);
        if (idPermit.verifySignature()) {
            serverHandler.installIDPermit(idPermit);
            tr.writeByte((byte)1);
        } else {
            tr.writeByte((byte)7);
        }
    }

    @Override
    public void doClientSide(ClientProtocol parentProtocol) throws IOException, ActionException, CryptogException {
        DataTransport tr = parentProtocol.getTransport();
        Domain domain = (Domain)parentProtocol.getValue(ProtocolConstants.DOMAIN_TO_CONNECT);
        String idName = (String)parentProtocol.getValue(ProtocolConstants.ID_NAME);
        String secretKey = (String)parentProtocol.getValue(ProtocolConstants.SECRET_KEY);
        JSlopeIDPermit idPermit = new JSlopeIDPermit(idName, secretKey, domain);
        idPermit.serialize(tr);
        Boolean retVal = tr.readByte() == 1;
        parentProtocol.setValue(ProtocolConstants.BOOLEAN_RESULT, retVal);
    }
}

