/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.io.protocol.impl;

import com.jslope.io.protocol.Protocols;
import com.jslope.io.protocol.impl.AbstractProtocol;
import com.jslope.io.protocol.impl.FinalProtocol;
import com.jslope.io.protocol.impl.actions.ProtocolAction;
import com.jslope.io.protocol.impl.actions.SwitchAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProtocolKeeper {
    private static volatile boolean isInitialized = false;
    private static volatile boolean nowIsInitializing = false;
    private static Class<? extends AbstractProtocol> rootProtocolClass;
    private static Map<Class<? extends AbstractProtocol>, List<ProtocolAction>> protocols;
    private static Map<Class<? extends AbstractProtocol>, List<ProtocolAction>> protocolStacks;
    private static Map<Class<? extends AbstractProtocol>, Class<? extends AbstractProtocol>> parents;

    public static List<ProtocolAction> getProtocolStack(Class<? extends AbstractProtocol> protocolClass) {
        ProtocolKeeper.checkInitialization();
        return protocolStacks.get(protocolClass);
    }

    private static void checkInitialization() {
        if (!isInitialized) {
            ProtocolKeeper.initialize();
        }
    }

    public static synchronized void initialize() {
        if (isInitialized) {
            return;
        }
        nowIsInitializing = true;
        AbstractProtocol rootProtocol = ProtocolKeeper.getRootProtocol();
        rootProtocolClass = rootProtocol.getClass();
        rootProtocol.initialize();
        nowIsInitializing = false;
        isInitialized = true;
    }

    private static AbstractProtocol getRootProtocol() {
        return Protocols.getRootProtocolnew();
    }

    public static void addAction(Class<? extends AbstractProtocol> aClass, ProtocolAction action) {
        if (nowIsInitializing) {
            if (!protocols.containsKey(aClass)) {
                protocols.put(aClass, new ArrayList());
            }
        } else {
            throw new RuntimeException("Tried to add action while nowIsInitializing == false");
        }
        protocols.get(aClass).add(action);
    }

    public static void protocolFinishedInit(Class<? extends AbstractProtocol> aClass, Class<? extends AbstractProtocol> parent) {
        if (aClass.getSuperclass().equals(FinalProtocol.class)) {
            ArrayList<ProtocolAction> stack = new ArrayList<ProtocolAction>();
            Class<? extends AbstractProtocol> currentProtocol = aClass;
            Class<? extends AbstractProtocol> previousProtocol = null;
            while (!ProtocolKeeper.isRoot(currentProtocol)) {
                ProtocolKeeper.addProtocolToStack(currentProtocol, previousProtocol, stack);
                previousProtocol = currentProtocol;
                currentProtocol = parents.get(currentProtocol);
            }
            ProtocolKeeper.addProtocolToStack(currentProtocol, previousProtocol, stack);
            protocolStacks.put(aClass, stack);
        }
    }

    public static void setParent(Class<? extends AbstractProtocol> aClass, Class<? extends AbstractProtocol> parent) {
        if (parents.containsKey(aClass)) {
            throw new RuntimeException("parents already contains aClass during initialization (possible double initialization of the same class)" + aClass);
        }
        parents.put(aClass, parent);
    }

    private static void addProtocolToStack(Class<? extends AbstractProtocol> currentProtocol, Class<? extends AbstractProtocol> previousProtocol, List<ProtocolAction> stack) {
        List<ProtocolAction> newStack = protocols.get(currentProtocol);
        if (previousProtocol != null) {
            SwitchAction switchAction = (SwitchAction)newStack.get(newStack.size() - 1);
            switchAction = switchAction.newClone();
            switchAction.setClientSwitch(previousProtocol);
            newStack.set(newStack.size() - 1, switchAction);
        }
        stack.addAll(0, newStack);
    }

    private static boolean isRoot(Class<? extends AbstractProtocol> currentProtocol) {
        return currentProtocol == rootProtocolClass;
    }

    public static List<ProtocolAction> getProtocolActions(Class<? extends AbstractProtocol> aClass) {
        ProtocolKeeper.checkInitialization();
        return protocols.get(aClass);
    }

    static {
        protocols = new HashMap<Class<? extends AbstractProtocol>, List<ProtocolAction>>();
        protocolStacks = new HashMap<Class<? extends AbstractProtocol>, List<ProtocolAction>>();
        parents = new HashMap<Class<? extends AbstractProtocol>, Class<? extends AbstractProtocol>>();
    }
}

