/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.framework;

import com.jslope.framework.DNS;
import com.jslope.io.protocol.Address;
import com.jslope.io.protocol.ClientHandler;
import com.jslope.io.protocol.Protocol;
import com.jslope.io.protocol.ProtocolConstants;
import com.jslope.io.protocol.Protocols;
import com.jslope.io.protocol.errorhandling.ErrorHandler;
import com.jslope.security.Domain;
import com.jslope.security.PublicDomain;
import com.jslope.security.PublicID;
import com.jslope.security.SecureID;
import com.jslope.security.impl.IDFactory;
import java.util.HashSet;
import java.util.Set;

public class DomainManager {
    public static boolean installDomainOnServer(Domain domain, Address serverAddress, String serverIDname, String secretKey, ErrorHandler errorHandler) {
        Protocol protocol = Protocols.getInstallDomainProtocol(serverIDname, domain);
        protocol.setValue(ProtocolConstants.SECRET_KEY, secretKey);
        protocol.setErrorHandler(errorHandler);
        if (!protocol.clientSideStart(serverAddress)) {
            return false;
        }
        return DomainManager.updateDNSForDomain(domain, serverAddress, errorHandler);
    }

    public static boolean updateDNSForDomain(Domain domainToBeUpdated, Address newDomainAddress, ErrorHandler errorHandler) {
        PublicDomain parent = domainToBeUpdated.getParent();
        if (parent == null) {
            errorHandler.addError("Parent domain is null", "Parent domain for " + domainToBeUpdated + " is null");
        }
        Address parentHostAddress = parent.getHostAddress();
        Protocol protocol = Protocols.getUpdateDNSProtocol(domainToBeUpdated, newDomainAddress, errorHandler);
        return protocol.clientSideStart(parentHostAddress);
    }

    public static boolean isDomainInstalled(Address serverAddress, String domainName, ErrorHandler errorHandler) {
        Protocol protocol = Protocols.getCheckDomainProtocol();
        protocol.setErrorHandler(errorHandler);
        protocol.setValue(ProtocolConstants.DOMAIN_NAME, domainName);
        protocol.clientSideStart(serverAddress);
        return protocol.getBooleanResult();
    }

    public static boolean removeDomain(Address serverAddress, Domain domain, ErrorHandler errorHandler) {
        Protocol protocol = Protocols.getRemoveDomainProtocol();
        protocol.setErrorHandler(errorHandler);
        protocol.setValue(ProtocolConstants.DOMAIN, domain);
        protocol.setValue(ProtocolConstants.DOMAIN_NAME_TO_CONNECT, domain.getPublicPart().getName());
        protocol.clientSideStart(serverAddress);
        return protocol.getBooleanResult();
    }

    public static boolean createIDPermit(Domain domain, String idName, String secretKey, ErrorHandler errorHandler) {
        Protocol protocol = Protocols.getInstallIDPermitProtocol();
        protocol.setErrorHandler(errorHandler);
        System.out.println("creating id permit for idName = \"" + idName + "\"");
        protocol.setValue(ProtocolConstants.DOMAIN_TO_CONNECT, domain);
        protocol.setValue(ProtocolConstants.ID_NAME, idName);
        protocol.setValue(ProtocolConstants.SECRET_KEY, secretKey);
        protocol.clientSideStart(domain.getPublicPart().getHostAddress());
        return protocol.getBooleanResult();
    }

    public static boolean removeIDPermit(Domain domain, String idName, ErrorHandler errorHandler) {
        Protocol protocol = Protocols.getRemoveIDPermitProtocol();
        protocol.setErrorHandler(errorHandler);
        protocol.setValue(ProtocolConstants.DOMAIN_TO_CONNECT, domain);
        protocol.setValue(ProtocolConstants.ID_NAME, idName);
        protocol.clientSideStart(domain.getPublicPart().getHostAddress());
        return protocol.getBooleanResult();
    }

    public static boolean isPermitInstalled(Domain domain, String idName, ErrorHandler errorHandler) {
        Protocol protocol = Protocols.getIsIDPermitProtocol();
        protocol.setErrorHandler(errorHandler);
        protocol.setValue(ProtocolConstants.DOMAIN_TO_CONNECT, domain);
        protocol.setValue(ProtocolConstants.ID_NAME, idName);
        protocol.clientSideStart(domain.getPublicPart().getHostAddress());
        return protocol.getBooleanResult();
    }

    public static boolean sendIDForSigning(PublicID publicID, String secretKey, ErrorHandler errorHandler) {
        Protocol protocol = Protocols.getSendIDForSigningProtocol();
        protocol.setErrorHandler(errorHandler);
        protocol.setValue(ProtocolConstants.UNSIGNED_ID, publicID);
        protocol.setValue(ProtocolConstants.SECRET_KEY, secretKey);
        String domainName = publicID.getDomainName();
        System.out.println("Domain name = " + domainName);
        protocol.clientSideStart(DNS.getAddress(domainName, errorHandler));
        return protocol.getBooleanResult();
    }

    public static Set<PublicID> signIDsOnServer(Domain signedDomain, ErrorHandler errorHandler) {
        Protocol protocol = Protocols.getSignIDOnServerProtocol();
        protocol.setErrorHandler(errorHandler);
        protocol.setValue(ProtocolConstants.DOMAIN_TO_CONNECT, signedDomain);
        protocol.clientSideStart(signedDomain.getPublicPart().getHostAddress());
        boolean isEverythingOk = protocol.getBooleanResult();
        Set unsignedIDs = isEverythingOk ? (Set)protocol.getValue(ProtocolConstants.UNSIGNED_ID) : new HashSet();
        return unsignedIDs;
    }

    public static boolean isIDOnServer(String idName, ErrorHandler errorHandler) {
        Protocol protocol = Protocols.getIsIDOnServerProtocol();
        protocol.setErrorHandler(errorHandler);
        protocol.setValue(ProtocolConstants.ID_NAME, idName);
        protocol.clientSideStart(DNS.getAddress(IDFactory.getDomainName(idName)));
        return protocol.getBooleanResult();
    }

    public static boolean removeAccountFromServer(String idName, Domain domain, ErrorHandler errorHandler) {
        Protocol protocol = Protocols.getRemoveAccountFromServerProtocol();
        protocol.setErrorHandler(errorHandler);
        protocol.setValue(ProtocolConstants.DOMAIN_TO_CONNECT, domain);
        protocol.setValue(ProtocolConstants.ID_NAME, idName);
        protocol.clientSideStart(domain.getPublicPart().getHostAddress());
        return protocol.getBooleanResult();
    }

    public static boolean installIDOnServer(Domain domain, PublicID publicID, ErrorHandler errorHandler) {
        Protocol protocol = Protocols.getInstallIDOnServer();
        protocol.setErrorHandler(errorHandler);
        protocol.setValue(ProtocolConstants.DOMAIN_TO_CONNECT, domain);
        protocol.setValue(ProtocolConstants.PUBLIC_ID, publicID);
        protocol.clientSideStart(domain.getPublicPart().getHostAddress());
        return protocol.getBooleanResult();
    }

    public static void listenToServer(Domain domain, ErrorHandler errorHandler, ClientHandler clientHandler) {
        Protocol protocol = Protocols.getListenToServer();
        protocol.setErrorHandler(errorHandler);
        protocol.setValue(ProtocolConstants.DOMAIN_TO_CONNECT, domain);
        protocol.setValue(ProtocolConstants.CLIENT_HANDLER, clientHandler);
        protocol.setValue(ProtocolConstants.DOMAIN_NAME, domain.getName());
        protocol.clientSideStart(domain.getPublicPart().getHostAddress());
    }

    public static void listenClientToServer(SecureID unsignedID, ErrorHandler errorHandler, ClientHandler clientHandler) {
        Protocol protocol = Protocols.getListenClientToServer();
        protocol.setErrorHandler(errorHandler);
        protocol.setValue(ProtocolConstants.UNSIGNED_ID, unsignedID);
        protocol.setValue(ProtocolConstants.CLIENT_HANDLER, clientHandler);
        String domainName = IDFactory.getDomainName(unsignedID.getName());
        protocol.setValue(ProtocolConstants.DOMAIN_NAME_TO_CONNECT, domainName);
        Address address = DNS.getAddress(domainName, errorHandler);
        protocol.clientSideStart(address);
    }
}

