/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.client.ui.view.treeviewers;

import com.jslope.client.ui.model.Directory;
import com.jslope.client.ui.persistent.MessageRecord;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class MessageTableModel
implements TableModel {
    List<MessageRecord> messages = new LinkedList<MessageRecord>();
    static final String[] columns = new String[]{"From", "To", "Subject", "Received"};
    List<TableModelListener> listeners = new LinkedList<TableModelListener>();

    MessageTableModel() {
    }

    @Override
    public int getRowCount() {
        return this.messages.size();
    }

    @Override
    public int getColumnCount() {
        return columns.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return columns[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public MessageRecord getMessage(int rowIndex) {
        return this.messages.get(rowIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        MessageRecord msg = this.getMessage(rowIndex);
        String retValue = " null ";
        switch (columnIndex) {
            case 0: {
                retValue = msg.getFrom();
                break;
            }
            case 1: {
                retValue = msg.getTo();
                break;
            }
            case 2: {
                retValue = msg.getSubject();
                break;
            }
            case 3: {
                retValue = msg.getReceivedDate();
            }
        }
        return retValue;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    public void setDirectory(Directory directory) {
        this.messages = MessageRecord.getMessagesForDirectory(directory);
        this.updateTable();
    }

    public void fireTableChanged(TableModelEvent e) {
        for (TableModelListener listener : this.listeners) {
            listener.tableChanged(e);
        }
    }

    public void updateTable() {
        TableModelEvent event = new TableModelEvent(this);
        this.fireTableChanged(event);
    }

    public int getIndex(MessageRecord messageRecord) {
        return this.messages.indexOf(messageRecord);
    }

    public void deleteMessageAt(int rowNumber) {
        this.messages.remove(rowNumber);
        this.updateTable();
    }

    public Set<MessageRecord> deleteMessages(int[] selectedRows) {
        HashSet<MessageRecord> messagesToDelete = new HashSet<MessageRecord>();
        for (int row : selectedRows) {
            messagesToDelete.add(this.getMessage(row));
        }
        this.messages.removeAll(messagesToDelete);
        this.updateTable();
        return messagesToDelete;
    }
}

