/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.client.ui.view;

import com.jslope.client.app.Icons;
import com.jslope.client.app.MessageDispatcher;
import com.jslope.client.app.SlowEvent;
import com.jslope.client.app.SlowEventQueue;
import com.jslope.client.ui.persistent.AccountRecord;
import com.jslope.client.ui.persistent.AttachmentRecord;
import com.jslope.client.ui.persistent.AttachmentRef;
import com.jslope.client.ui.persistent.MessageRecord;
import com.jslope.client.ui.view.AccountsComboboxModel;
import com.jslope.client.ui.view.attachments.AttachmentList;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;

public class ComposeMessageFrame
extends JFrame {
    ComboBoxModel fromAddressModel;
    AttachmentList attachmentList;
    MessageRecord parentMessage;
    JButton sendButton;
    long previousTime = 0L;
    static final long saveInterval = 30000L;
    boolean isModified = false;
    int oldDividerLocation = 200;
    private JPanel StatusPanel;
    private Component attachementPane;
    private JToolBar composeMessageToolbar;
    private JComboBox fromField;
    private JLabel fromLabel;
    private JLabel jLabel1;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenuBar jMenuBar1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JPanel mainPanel;
    private JTextArea messageText;
    private JTextField subjectField;
    private JLabel subjectLabel;
    private JTextField toField;
    private JLabel toLabel;

    public ComposeMessageFrame(MessageRecord messageRecord) {
        this.parentMessage = messageRecord;
        AccountRecord from = AccountRecord.getAccountRecord(this.parentMessage.getFrom());
        this.fromAddressModel = new AccountsComboboxModel(from);
        this.attachmentList = new AttachmentList(true);
        this.initComponents();
        this.setText(this.parentMessage.getText());
        this.setSubject(this.parentMessage.getSubject());
        this.setTo(this.parentMessage.getTo());
        this.initListeners();
        this.loadAttachmentInfo();
        if (this.attachmentList.hasAttachments()) {
            this.showAttachements();
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ComposeMessageFrame.this.saveIfNotSaved();
            }
        });
    }

    public void setTo(String to) {
        this.toField.setText(to);
    }

    public void setSubject(String subject) {
        this.subjectField.setText(subject);
    }

    public void setText(String newText) {
        this.messageText.setText(newText);
    }

    public void activateTextComponent() {
        this.messageText.requestFocusInWindow();
        this.messageText.setCaretPosition(0);
    }

    private void initListeners() {
        SendAction sendAction = new SendAction(this);
        this.sendButton = new JButton();
        this.sendButton.setAction(sendAction);
        this.sendButton.setIcon(Icons.sendMail);
        this.sendButton.setToolTipText("Send Message");
        this.sendButton.setFocusable(false);
        this.sendButton.setHorizontalTextPosition(0);
        this.sendButton.setVerticalTextPosition(3);
        this.composeMessageToolbar.add(this.sendButton);
        JButton attachementButton = new JButton();
        attachementButton.setIcon(Icons.attachementsIcon);
        attachementButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComposeMessageFrame.this.attachFiles();
            }
        });
        this.messageText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ComposeMessageFrame.this.checkToUpdateMessage();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ComposeMessageFrame.this.checkToUpdateMessage();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ComposeMessageFrame.this.checkToUpdateMessage();
            }
        });
        this.composeMessageToolbar.add(attachementButton);
        this.hideAtachements();
    }

    private void checkToUpdateMessage() {
        long currentTime = System.currentTimeMillis();
        if (currentTime > this.previousTime + 30000L) {
            this.previousTime = currentTime;
            this.saveMessage();
        } else {
            this.isModified = true;
        }
    }

    private void saveIfNotSaved() {
        if (this.isModified) {
            System.out.println("Saving message");
            this.saveMessage();
            this.isModified = false;
        }
    }

    private void saveMessage() {
        this.updateMessageInfo();
        SlowEventQueue.putEvent(new SlowEvent(){

            @Override
            public void executeAction() {
                ComposeMessageFrame.this.parentMessage.save();
            }
        });
    }

    private void attachFiles() {
        JFileChooser fc = new JFileChooser();
        fc.setMultiSelectionEnabled(true);
        int returnVal = fc.showDialog(this, "Select files to attach to message");
        if (returnVal == 0) {
            File[] files;
            this.saveMessage();
            for (File file : files = fc.getSelectedFiles()) {
                if (!file.isFile() || file.isDirectory() || file.length() <= 40000000L) continue;
                JOptionPane.showMessageDialog(this, "The " + file.getName() + " is too big, maximum length is 35Mb", "The attachment is too big", 0);
                return;
            }
            SlowEventQueue.putEvent(new SaveAttachmentsEvent(files));
            this.showAttachements();
        }
    }

    private void loadAttachmentInfo() {
        List<AttachmentRef> addedAttachments = AttachmentRecord.getAttachmentRefs(this.parentMessage);
        this.attachmentList.setFiles(addedAttachments);
    }

    private void showAttachements() {
        this.attachementPane.setVisible(true);
        this.jSplitPane1.setDividerLocation(this.oldDividerLocation);
    }

    private void hideAtachements() {
        this.oldDividerLocation = this.jSplitPane1.getDividerLocation();
        this.attachementPane.setVisible(false);
    }

    private void initComponents() {
        this.composeMessageToolbar = new JToolBar();
        this.mainPanel = new JPanel();
        this.StatusPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.messageText = new JTextArea();
        this.jSplitPane1 = new JSplitPane();
        this.attachementPane = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jPanel2 = new JPanel();
        this.fromField = new JComboBox();
        this.fromLabel = new JLabel();
        this.toField = new JTextField();
        this.toLabel = new JLabel();
        this.subjectField = new JTextField();
        this.subjectLabel = new JLabel();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenu2 = new JMenu();
        this.setDefaultCloseOperation(2);
        this.composeMessageToolbar.setRollover(true);
        this.getContentPane().add((Component)this.composeMessageToolbar, "North");
        GroupLayout StatusPanelLayout = new GroupLayout((Container)this.StatusPanel);
        this.StatusPanel.setLayout((LayoutManager)StatusPanelLayout);
        StatusPanelLayout.setHorizontalGroup((GroupLayout.Group)StatusPanelLayout.createParallelGroup(1).add(0, 572, Short.MAX_VALUE));
        StatusPanelLayout.setVerticalGroup((GroupLayout.Group)StatusPanelLayout.createParallelGroup(1).add(0, 18, Short.MAX_VALUE));
        this.messageText.setColumns(20);
        this.messageText.setRows(5);
        Font font = this.messageText.getFont();
        font = new Font(font.getName(), font.getStyle(), 19);
        this.messageText.setFont(font);
        this.jScrollPane1.setViewportView(this.messageText);
        this.jSplitPane1.setDividerLocation(450);
        this.jLabel1.setText("Atachements:");
        this.attachementPane = this.attachmentList.getRepresentation();
        this.jSplitPane1.setRightComponent(this.attachementPane);
        this.fromField.setModel(this.fromAddressModel);
        this.fromField.setToolTipText("Select From Address");
        this.fromLabel.setText("From:");
        this.toLabel.setText("To:");
        this.subjectLabel.setText("Subject:");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2).add((Component)this.fromLabel).add((Component)this.subjectLabel).add((Component)this.toLabel)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.fromField, 0, 385, Short.MAX_VALUE).add(2, (Component)this.toField, -1, 385, Short.MAX_VALUE).add((Component)this.subjectField, -1, 385, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.fromField, -2, -1, -2).add((Component)this.fromLabel)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.toField, -2, -1, -2).add((Component)this.toLabel)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.subjectLabel).add((Component)this.subjectField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jSplitPane1.setLeftComponent(this.jPanel2);
        GroupLayout mainPanelLayout = new GroupLayout((Container)this.mainPanel);
        this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
        mainPanelLayout.setHorizontalGroup((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((Component)this.StatusPanel, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jScrollPane1, -1, 572, Short.MAX_VALUE).add((Component)this.jSplitPane1, -1, 572, Short.MAX_VALUE));
        mainPanelLayout.setVerticalGroup((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.jSplitPane1, -2, this.jPanel2.getPreferredSize().height, -2).addPreferredGap(0).add((Component)this.jScrollPane1, -2, 356, Short.MAX_VALUE).add((Component)this.StatusPanel, -2, -1, -2)));
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.jMenu1.setText("File");
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText("Edit");
        this.jMenuBar1.add(this.jMenu2);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void sendMessage() {
        System.out.println("Sending message");
        this.updateParentMessage();
        MessageDispatcher.dispatch(this.parentMessage);
        this.setVisible(false);
        this.dispose();
    }

    private void updateParentMessage() {
        this.updateMessageInfo();
        this.parentMessage.save();
    }

    private void updateMessageInfo() {
        this.parentMessage.setSubject(this.getSubject());
        this.parentMessage.setFrom(this.getFromAsText());
        this.parentMessage.setTo(this.getTo());
        this.parentMessage.setText(this.getMessageText());
    }

    private AccountRecord getFromRecord() {
        return (AccountRecord)this.fromField.getSelectedItem();
    }

    private String getMessageText() {
        return this.messageText.getText();
    }

    private String getTo() {
        return this.toField.getText();
    }

    private String getFromAsText() {
        return this.getFromRecord().getSecureID().getName();
    }

    private String getSubject() {
        return this.subjectField.getText();
    }

    class SendAction
    extends AbstractAction {
        ComposeMessageFrame parent;

        SendAction(ComposeMessageFrame parentFrame) {
            this.parent = parentFrame;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.parent.sendMessage();
        }
    }

    class SaveAttachmentsEvent
    implements SlowEvent {
        File[] files;

        SaveAttachmentsEvent(File[] files) {
            this.files = files;
        }

        @Override
        public void executeAction() {
            AttachmentRecord.addAttachments(ComposeMessageFrame.this.parentMessage, this.files);
            ComposeMessageFrame.this.loadAttachmentInfo();
        }
    }
}

