/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.client.domainmanager;

import com.jslope.client.domainmanager.DomainManagerDialog;
import com.jslope.client.protocol.UIErrorHandler;
import com.jslope.client.ui.MainWindow;
import com.jslope.client.ui.dialog.AbstractOkCancelDialog;
import com.jslope.framework.DomainManager;
import com.jslope.io.protocol.Address;
import com.jslope.security.Domain;
import com.jslope.security.utils.Validators;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class UpdateDomainServerDialog
extends AbstractOkCancelDialog {
    private JTextField address;
    private Domain domain;

    private UpdateDomainServerDialog(Domain domain) {
        super(MainWindow.getInstance(), "Install Domain on server", false);
        this.domain = domain;
        JLabel domainName = new JLabel(domain.getName());
        this.addComponent("domainName:", domainName);
        this.address = new JTextField(15);
        this.addComponent("address:", this.address);
        this.finishDialog();
    }

    @Override
    protected boolean validateAction() {
        String serverAddress = this.getServerAddress();
        if (!Validators.validateAddress(serverAddress)) {
            JOptionPane.showMessageDialog(this, "Please enter a valid server address", "Server address is invalid", 0);
            return false;
        }
        return DomainManager.updateDNSForDomain(this.domain, new Address(serverAddress), new UIErrorHandler(DomainManagerDialog.getInstance()));
    }

    private String getServerAddress() {
        return this.address.getText();
    }

    public static void updateDomain(Domain selectedDomain) {
        new UpdateDomainServerDialog(selectedDomain).setVisible(true);
    }
}

