/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.client.app;

import com.jslope.client.ui.MainWindow;
import com.jslope.client.ui.persistent.AccountRecord;
import com.jslope.client.ui.persistent.DirectoryRecord;
import com.jslope.client.ui.persistent.MessageRecord;
import com.jslope.io.protocol.messages.OpenMessage;
import com.jslope.logger.Log;
import com.jslope.security.crypto.impl.CryptogException;
import java.util.List;

public class MessageReceiver
implements Runnable {
    AccountRecord accountRecord;

    private MessageReceiver(AccountRecord forAccountRecord) {
        this.accountRecord = forAccountRecord;
    }

    @Override
    public void run() {
        try {
            Log.debug("Will start receive mail for account ");
            List<OpenMessage> messages = this.accountRecord.getSecureID().receive(MainWindow.getNewSystemErrorHandler());
            DirectoryRecord inbox = this.accountRecord.getInboxDir();
            for (OpenMessage message : messages) {
                MessageRecord messageRecord = new MessageRecord();
                messageRecord.setOpenMessage(message);
                messageRecord.setParent(inbox);
                messageRecord.save();
            }
            inbox.updateUI();
        }
        catch (CryptogException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static void forAccount(AccountRecord accountRecord) {
        MessageReceiver messageReceiver = new MessageReceiver(accountRecord);
        new Thread(messageReceiver).start();
    }
}

