/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.security.impl;

import com.jslope.io.protocol.Address;
import com.jslope.io.stream.AdvancedDataInput;
import com.jslope.io.stream.AdvancedDataOutput;
import com.jslope.io.stream.impl.AdvancedByteDataOutputStream;
import com.jslope.logger.Log;
import com.jslope.security.PublicDomain;
import com.jslope.security.PublicID;
import com.jslope.security.SignedMessage;
import com.jslope.security.crypto.EncryptedBytes;
import com.jslope.security.crypto.JSlopePublicKey;
import com.jslope.security.crypto.impl.CryptogException;
import com.jslope.security.crypto.impl.RSAPublicKey;
import com.jslope.security.crypto.utils.Utils;
import com.jslope.security.impl.AbstractSecureObject;
import com.jslope.security.impl.IDFactory;
import com.jslope.security.impl.JSlopePublicDomain;
import java.io.File;
import java.io.IOException;

public class JSlopePublicID
extends AbstractSecureObject
implements PublicID {
    private JSlopePublicKey encryptor;
    private JSlopePublicKey signVerifier;
    private String name;
    private JSlopePublicDomain domain;
    private long signatureTime = 0L;
    private byte[] internalSignature;
    private boolean isSigned;

    public JSlopePublicID(JSlopePublicKey cryptor, JSlopePublicKey signer, String name) {
        this.encryptor = cryptor;
        this.signVerifier = signer;
        this.name = name;
    }

    public JSlopePublicID() {
    }

    @Override
    public String show() {
        if (this.name != null && this.domain != null) {
            return this.name + this.domain.getName();
        }
        return " *null* name: " + this.name + " domain: " + this.domain;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void updateSignTime() {
        this.signatureTime = System.currentTimeMillis();
    }

    @Override
    public byte[] getUnsignedData() {
        AdvancedByteDataOutputStream dos = new AdvancedByteDataOutputStream();
        try {
            this.serializeBytesForSigning(dos);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return dos.toByteArray();
    }

    private void serializeBytesForSigning(AdvancedDataOutput dos) throws IOException {
        dos.writeUTF(this.name);
        dos.writeLong(this.signatureTime);
        this.encryptor.serialize(dos);
        this.signVerifier.serialize(dos);
    }

    private void deserializeBytesForSigning(AdvancedDataInput bis) throws IOException {
        this.name = bis.readUTF();
        this.signatureTime = bis.readLong();
        this.encryptor = new RSAPublicKey();
        this.signVerifier = new RSAPublicKey();
        this.encryptor.deserialize(bis);
        this.signVerifier.deserialize(bis);
    }

    @Override
    public void setSignature(byte[] signature, JSlopePublicDomain publicDomain) {
        this.internalSignature = signature;
        this.domain = publicDomain;
        this.isSigned = true;
    }

    public byte[] getData() {
        AdvancedByteDataOutputStream dos = new AdvancedByteDataOutputStream();
        try {
            this.serialize(dos);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return dos.toByteArray();
    }

    @Override
    public void serialize(AdvancedDataOutput oos) throws IOException {
        this.serializeBytesForSigning(oos);
        oos.writeBoolean(this.isSigned);
        if (this.isSigned) {
            oos.writeBytes(this.internalSignature);
            this.domain.serialize(oos);
        }
    }

    @Override
    public void deserialize(AdvancedDataInput bis) throws IOException {
        this.deserializeBytesForSigning(bis);
        this.isSigned = bis.readBoolean();
        if (this.isSigned) {
            this.internalSignature = bis.readBytes();
            this.domain = new JSlopePublicDomain();
            this.domain.deserialize(bis);
        }
    }

    @Override
    public boolean verifyInternalSignature() throws CryptogException {
        if (this.isSigned) {
            if (this.domain.verifySignature(this.getUnsignedData(), this.internalSignature)) {
                return this.domain.verifyInternalSignature();
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean isSigned() {
        return this.isSigned;
    }

    @Override
    public boolean verifySignature(SignedMessage signedMessage) throws CryptogException {
        if (this.isSigned && this.isEqual(signedMessage.getPublicID())) {
            return this.verifySignature(signedMessage.getBytes(), signedMessage.getSignature());
        }
        return false;
    }

    @Override
    public boolean verifySignature(byte[] message, byte[] externalSignatureToVerify) throws CryptogException {
        if (this.verifyInternalSignature()) {
            return this.signVerifier.isValid(message, externalSignatureToVerify);
        }
        return false;
    }

    @Override
    public EncryptedBytes encryptBytes(byte[] byteMessage) throws CryptogException {
        return this.encryptor.encrypt(byteMessage);
    }

    @Override
    public byte[] encryptLowLevelBytes(byte[] bytes) throws CryptogException {
        return this.encryptor.encryptLowLevel(bytes);
    }

    @Override
    public Address getDomainAddress() {
        return this.domain.getHostAddress();
    }

    @Override
    public String getDomainName() {
        return IDFactory.getDomainName(this.getName());
    }

    @Override
    public PublicDomain getDomain() {
        return this.domain;
    }

    @Override
    public boolean isEqualWithUnsingedID(PublicID publicPart) {
        return Utils.compareBytes(this.getIdentificationUnsignedBytes(), ((JSlopePublicID)publicPart).getIdentificationUnsignedBytes());
    }

    @Override
    public void detailedCompare(PublicID publicID) {
        byte[] otherBytes;
        byte[] myBytes = this.getIdentificationUnsignedBytes();
        if (myBytes.length != (otherBytes = ((JSlopePublicID)publicID).getIdentificationUnsignedBytes()).length) {
            Log.error("Byte lengths aren't equal " + myBytes.length + " != " + otherBytes.length);
        } else {
            Log.debug("Byte lengths are equal: " + myBytes.length);
            Log.debug("Bytes for 1:" + Utils.showBytes(myBytes));
            Log.debug("Bytes for 2:" + Utils.showBytes(otherBytes));
        }
        try {
            if (publicID.verifyInternalSignature()) {
                Log.debug("Internal signature is ok");
            } else {
                Log.error("Internal signature broken");
            }
        }
        catch (CryptogException e) {
            e.printStackTrace();
        }
    }

    private byte[] getIdentificationUnsignedBytes() {
        AdvancedByteDataOutputStream dos = new AdvancedByteDataOutputStream();
        try {
            this.encryptor.serialize(dos);
            this.signVerifier.serialize(dos);
            dos.writeUTF(this.getName());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return dos.toByteArray();
    }

    @Override
    public File defaultFile() {
        return new File(this.getName() + ".public");
    }

    public String toString() {
        return this.name;
    }
}

