/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.security.impl;

import com.jslope.io.stream.AdvancedDataInput;
import com.jslope.io.stream.AdvancedDataOutput;
import com.jslope.io.stream.StreamSerializable;
import com.jslope.io.stream.impl.AdvancedByteDataOutputStream;
import com.jslope.security.Domain;
import com.jslope.security.PublicDomain;
import com.jslope.security.PublicID;
import com.jslope.security.crypto.JSlopePrivateKey;
import com.jslope.security.crypto.impl.CryptogException;
import com.jslope.security.crypto.impl.RSAKeyPair;
import com.jslope.security.crypto.impl.RSAPrivateKey;
import com.jslope.security.crypto.utils.Utils;
import com.jslope.security.impl.AbstractSecureObject;
import com.jslope.security.impl.JSlopePublicDomain;
import java.io.File;
import java.io.IOException;

public class JSlopeDomain
extends AbstractSecureObject
implements Domain {
    JSlopePrivateKey privateKey = new RSAPrivateKey();
    JSlopePublicDomain publicPart = new JSlopePublicDomain();

    protected JSlopeDomain() {
    }

    @Override
    public void generate() {
        this.generate(false);
    }

    @Override
    public PublicDomain getPublicPart() {
        return this.publicPart;
    }

    @Override
    public void setName(String name) {
        this.publicPart.setName(name);
    }

    @Override
    public void generate(boolean isRoot) {
        RSAKeyPair keyPair = new RSAKeyPair();
        keyPair.generate();
        this.privateKey = keyPair.getPrivateKey();
        this.publicPart = new JSlopePublicDomain(keyPair.getPublicKey(), isRoot);
    }

    @Override
    public void signSubdomain(PublicDomain publicDomain) throws CryptogException {
        if (!this.isNameASubdomain(publicDomain)) {
            throw new CryptogException("Extension of domain don't match");
        }
        publicDomain.updateSignTime();
        byte[] data = publicDomain.getData();
        byte[] signature = this.privateKey.sign(data);
        publicDomain.setSignature(signature, this.publicPart);
    }

    @Override
    public void signID(PublicID publicID) throws CryptogException {
        if (!this.isIDofThisDomain(publicID)) {
            throw new CryptogException("This id is not of this domain");
        }
        publicID.updateSignTime();
        byte[] data = publicID.getUnsignedData();
        byte[] signature = this.privateKey.sign(data);
        publicID.setSignature(signature, this.publicPart);
    }

    @Override
    public byte[] signExternalID(PublicID publicID) throws CryptogException {
        return this.sign(publicID);
    }

    @Override
    public PublicDomain getParent() {
        return this.getPublicPart().getParent();
    }

    @Override
    public byte[] signLowLevelBytes(byte[] bytesToSign) throws CryptogException {
        return this.privateKey.sign(bytesToSign);
    }

    @Override
    public byte[] sign(StreamSerializable object) throws CryptogException {
        AdvancedByteDataOutputStream out = new AdvancedByteDataOutputStream();
        try {
            object.serialize(out);
            byte[] toSign = out.toByteArray();
            return this.signLowLevelBytes(toSign);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to serialize object: " + object);
        }
    }

    @Override
    public boolean isNameASubdomain(PublicDomain publicDomain) {
        return this.isSuperdomain(publicDomain.getName(), ".");
    }

    private boolean isIDofThisDomain(PublicID publicID) {
        return this.isSuperdomain(publicID.getName(), "@");
    }

    private boolean isSuperdomain(String nameToSign, String divider) {
        int firstPoint = nameToSign.indexOf(divider);
        if (firstPoint <= 0) {
            return false;
        }
        String parentDomain = nameToSign.substring(firstPoint + 1);
        return parentDomain.equals(this.getName());
    }

    @Override
    public void reintegrate(PublicDomain publicDomain) throws CryptogException {
        if (this.getName().equals(publicDomain.getName()) && publicDomain.isSigned() && Utils.compareBytes(this.getPublicPart().getKeyData(), publicDomain.getKeyData())) {
            this.publicPart = (JSlopePublicDomain)publicDomain;
            return;
        }
        throw new CryptogException("Can't integrate public domain " + publicDomain.getName() + " into private domain " + this.getName());
    }

    @Override
    public String getName() {
        return this.getPublicPart().getName();
    }

    @Override
    public void serialize(AdvancedDataOutput oos) throws IOException {
        this.publicPart.serialize(oos);
        this.privateKey.serialize(oos);
    }

    @Override
    public void deserialize(AdvancedDataInput bis) throws IOException {
        this.publicPart.deserialize(bis);
        this.privateKey.deserialize(bis);
    }

    @Override
    protected File defaultFile() {
        return new File(this.getName() + ".domain");
    }

    public static Domain loadNewFromFile(File file) throws IOException {
        JSlopeDomain domain = new JSlopeDomain();
        domain.loadFromFile(file);
        return domain;
    }
}

