/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.security.crypto.utils;

import com.jslope.security.crypto.impl.CryptogException;
import java.security.SecureRandom;

public class JSlopeRandom {
    private static SecureRandom sr = new SecureRandom();

    public static SecureRandom getSecureRandom() {
        return sr;
    }

    public static byte[] getRandom(int numberOfBits) throws CryptogException {
        if (numberOfBits % 8 != 0) {
            throw new CryptogException(" Wrong number of bits ");
        }
        return JSlopeRandom.getRandomBytes(numberOfBits / 8);
    }

    private static byte[] getRandomBytes(int i) {
        byte[] retBytes = new byte[i];
        sr.nextBytes(retBytes);
        return retBytes;
    }

    public static void addSeed(byte[] seed) {
        sr.setSeed(seed);
    }
}

