/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.security.crypto.impl;

import com.jslope.io.stream.AdvancedDataInput;
import com.jslope.io.stream.AdvancedDataOutput;
import com.jslope.io.stream.StreamSerializable;
import com.jslope.security.crypto.impl.CryptogException;
import com.jslope.security.crypto.utils.Utils;
import java.io.IOException;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.encodings.OAEPEncoding;
import org.bouncycastle.crypto.engines.RSAEngine;

public abstract class RSAKey
implements StreamSerializable {
    CipherParameters key;

    public byte[] internalEncrypt(byte[] bytesForEncryption) throws CryptogException {
        RSAEngine cipher = new RSAEngine();
        OAEPEncoding engine = new OAEPEncoding((AsymmetricBlockCipher)cipher);
        engine.init(true, this.key);
        try {
            return engine.processBlock(bytesForEncryption, 0, bytesForEncryption.length);
        }
        catch (InvalidCipherTextException e) {
            e.printStackTrace();
            throw new CryptogException((Exception)((Object)e));
        }
    }

    public byte[] internalDecrypt(byte[] encrypted) throws CryptogException {
        RSAEngine cipher = new RSAEngine();
        OAEPEncoding engine = new OAEPEncoding((AsymmetricBlockCipher)cipher);
        engine.init(false, this.key);
        try {
            return engine.processBlock(encrypted, 0, encrypted.length);
        }
        catch (InvalidCipherTextException e) {
            e.printStackTrace();
            throw new CryptogException((Exception)((Object)e));
        }
    }

    public abstract byte[] getEncoded();

    public abstract void load(byte[] var1);

    public void show() {
        System.out.println(Utils.showBytes(this.getEncoded()));
    }

    @Override
    public void serialize(AdvancedDataOutput oos) throws IOException {
        oos.writeBytes(this.getEncoded());
    }

    @Override
    public void deserialize(AdvancedDataInput bis) throws IOException {
        this.load(bis.readBytes());
    }
}

