/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.persistence.sql;

import com.jslope.persistence.fields.BooleanField;
import com.jslope.persistence.fields.DateField;
import com.jslope.persistence.sql.BasicCondition;
import com.jslope.persistence.sql.LogicCondition;
import com.jslope.persistence.sql.SqlUtil;
import java.util.Date;
import java.util.List;

public class Condition
extends BasicCondition {
    public Condition() {
    }

    public Condition(String variable) {
        super(SqlUtil.getSqlServer().formatField(variable));
    }

    public Condition(String var, BasicCondition par) {
        super(SqlUtil.getSqlServer().formatField(var), par);
    }

    @Override
    public String toString() {
        return "";
    }

    public LogicCondition Equal(String nextVariable) {
        return this.addOperation(" = ", nextVariable);
    }

    public LogicCondition NotNull() {
        return this.addOperation(" IS NOT NULL ", null);
    }

    public LogicCondition LessThan(long nextVariable) {
        return this.LessThan("" + nextVariable);
    }

    public LogicCondition LessThan(String nextVariable) {
        return this.addOperation(" < ", nextVariable);
    }

    public LogicCondition MoreThan(String nextVariable) {
        return this.addOperation(" > ", nextVariable);
    }

    public LogicCondition MoreThanEqual(String nextVariable) {
        return this.addOperation(" >= ", nextVariable);
    }

    public LogicCondition MoreThan(long nextVariable) {
        return this.MoreThan("" + nextVariable);
    }

    public LogicCondition MoreThanEqual(long nextVariable) {
        return this.MoreThanEqual("" + nextVariable);
    }

    public LogicCondition LessThan(Date date) {
        return this.LessThan(SqlUtil.getSqlServer().dateToString(date));
    }

    public LogicCondition MoreThanEqual(Date date) {
        return this.MoreThanEqual(SqlUtil.getSqlServer().dateToString(date));
    }

    private LogicCondition addOperation(String newAction, String nextVariable) {
        this.action = newAction;
        return new LogicCondition(nextVariable, this);
    }

    public LogicCondition Equal(boolean value) {
        return this.Equal(BooleanField.booleanValue(value));
    }

    public LogicCondition Equal(Date value) {
        return this.Equal(DateField.dateValue(value));
    }

    public LogicCondition Equal(int value) {
        return this.Equal(String.valueOf(value));
    }

    @Override
    public String preparedString(String condition) {
        String retVal = this.value + this.action + condition;
        if (this.parent != null) {
            return this.parent.preparedString(retVal);
        }
        return retVal;
    }

    @Override
    public void prepareValues(List<String> list) {
        if (this.parent != null) {
            this.parent.prepareValues(list);
        }
    }

    public LogicCondition LessThanEqual(String nextVariable) {
        return this.addOperation(" <= ", nextVariable);
    }

    public LogicCondition LIKE(String nextVariable) {
        return this.addOperation(" LIKE ", nextVariable);
    }

    public LogicCondition LessThanEqual(long i) {
        return this.LessThanEqual("" + i);
    }

    public static Condition var(String var) {
        return new Condition(var);
    }

    public static Condition openBracket(String var) {
        Condition condition = new Condition("(");
        return new Condition(var, condition);
    }
}

