/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.persistence.fields;

import com.jslope.persistence.fields.Field;
import com.jslope.persistence.sql.SqlUtil;
import com.jslope.persistence.validators.IntValidator;

public class IntField
extends Field {
    public IntField(int n) {
        this();
        this.setDefaultValue(String.valueOf(n));
    }

    public IntField() {
        this.setValue("0");
        this.addValidator(new IntValidator());
    }

    @Override
    public void setValue(String value) {
        if (value == null || value.equals("null")) {
            value = "0";
        }
        super.setValue(value);
    }

    @Override
    public String getSQLType() {
        return SqlUtil.getSqlServer().getTypeForInt();
    }

    public int getIntValue() {
        return Integer.parseInt(this.getValue());
    }

    public void setIntValue(int value) {
        this.setValue(String.valueOf(value));
    }

    @Override
    public int getMaxLength() {
        return 10;
    }
}

