/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.persistence;

import com.jslope.persistence.Config;
import com.jslope.persistence.DBPersistentObject;
import com.jslope.persistence.PersistenceException;
import com.jslope.persistence.Type;
import com.jslope.persistence.sql.QueryException;
import com.jslope.persistence.sql.ResultIterator;
import com.jslope.persistence.sql.ResultRow;
import com.jslope.persistence.sql.SqlUtil;
import com.jslope.persistence.utils.Pair;
import com.jslope.persistence.utils.UtilMisc;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Hashtable;

public class Types {
    static final String typesTableName = Config.getTypesTableName();
    private static Types instance = new Types();
    private ArrayList<Type> types;
    private Hashtable<String, Type> byNames;
    private Hashtable<Integer, Type> byIDs;
    public static final int UNABLE_TO_LOAD_TYPE = -1;
    private static final String ClassName = "ClassName";
    private static final String TableName = "TableName";
    private static final String ClassID = "ClassID";
    public static final String TYPE_ID = "TypeID1";
    private static final int defaultOrder = -1;

    private Types() throws QueryException {
        this.reinitTypes();
    }

    public void reinitTypes() {
        try {
            this.initTypes();
        }
        catch (QueryException e) {
            try {
                System.out.println("Deploying database...");
                SqlUtil.getSqlServer().deploy();
                this.initTypes();
            }
            catch (QueryException e1) {
                throw new QueryException(e1.getMessage());
            }
        }
    }

    public static Types getInstance() {
        return instance;
    }

    private void initTypes() throws QueryException {
        this.byNames = new Hashtable();
        this.byIDs = new Hashtable();
        this.types = new ArrayList();
        ResultIterator result = SqlUtil.findByAnd(typesTableName, new String[]{ClassID, ClassName, TableName}, null);
        while (result.hasNext()) {
            ResultRow row = result.next();
            int classID = row.getInt(ClassID);
            String className = row.getString(ClassName);
            String table = row.getString(TableName);
            Type type = new Type();
            type.setClassId(classID);
            type.setClassName(className);
            type.setTableName(table);
            this.types.add(type);
            this.byNames.put(className, type);
            this.byIDs.put(new Integer(classID), type);
        }
        result = null;
    }

    public static boolean typeExists(String className) {
        return Types.getInstance().byNames.containsKey(className);
    }

    public static boolean typeExists(int typeID) {
        return Types.getInstance().byIDs.containsKey(typeID);
    }

    public static Type getType(int classID) {
        return Types.getInstance().byIDs.get(new Integer(classID));
    }

    public static Type getType(String className) {
        if (!Types.typeExists(className) && Types.classExists(className)) {
            Types.instantiateObject(className);
        }
        return Types.getInstance().byNames.get(className);
    }

    public static DBPersistentObject instantiateObject(String className) {
        Class<?> c = null;
        try {
            c = Class.forName(className);
            Constructor<?>[] constr = c.getConstructors();
            Object[] initArgs = new Object[]{};
            if (constr.length > 0) {
                DBPersistentObject obj = (DBPersistentObject)constr[0].newInstance(initArgs);
                return obj;
            }
            return null;
        }
        catch (Exception e) {
            System.out.println("Exception occured when trying to instantiate " + className);
            e.printStackTrace();
            return null;
        }
    }

    public static boolean classExists(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static String get(int classID) {
        return Types.getType(classID).getClassName();
    }

    public static int get(String className) {
        Type type = Types.getType(className);
        return type.getClassId();
    }

    public static String getTableName(String className) {
        Type type = Types.getType(className);
        return type.getTableName();
    }

    private static String tableFromClassName(String className) {
        return "obj_" + className.substring(className.lastIndexOf(".") + 1);
    }

    public static int addType(String className) {
        return Types.addTypePhisical(className, -1);
    }

    private static int addTypePhisical(String className, int order) {
        String tableName = Types.tableFromClassName(className);
        Pair[] pair = null;
        pair = order == -1 ? UtilMisc.toPair(ClassName, className, TableName, tableName) : UtilMisc.toPair(ClassID, "" + order, ClassName, className, TableName, tableName);
        if (SqlUtil.insert(typesTableName, pair)) {
            try {
                Types.getInstance().initTypes();
            }
            catch (QueryException e) {
                e.printStackTrace();
                return -1;
            }
            return Types.get(className);
        }
        return -1;
    }

    public static void addType(String name, int typeID) {
        if (Types.typeExists(typeID)) {
            System.out.println("Existing types:");
            Types.showTypes();
            throw new PersistenceException(" typeID " + typeID + " is already in use");
        }
        Types.addTypePhisical(name, typeID);
    }

    public static void showTypes() {
        Types types = Types.getInstance();
        for (Integer ID : types.byIDs.keySet()) {
            Type type = types.byIDs.get(ID);
            System.out.println("ID: " + ID + " Name: " + type.getTableName());
        }
    }

    public static Hashtable getFieldList(int typeID) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            ResultIterator itr = SqlUtil.findByAnd(DBPersistentObject.FIELDS_TABLE, new String[]{"FieldName", "FieldType"}, UtilMisc.toPair(TYPE_ID, new Integer(typeID)));
            while (itr.hasNext()) {
                ResultRow row = itr.next();
                String fName = row.getString("FieldName");
                String fType = row.getString("FieldType");
                result.put(fName, fType);
            }
        }
        catch (QueryException queryException) {
            // empty catch block
        }
        return result;
    }

    public static DBPersistentObject newObject(int type) {
        return DBPersistentObject.getNewObject(type);
    }

    public static Iterable<? extends String> getTableNames() {
        return Types.getInstance().byNames.keySet();
    }
}

