/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.persistence;

import com.jslope.persistence.Config;
import com.jslope.persistence.DatabaseInUseException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class DBConnection {
    private static Connection connection = null;

    public static void initialize() {
        block4: {
            String url = Config.getDBUrl();
            String user = Config.getDBUsername();
            String password = Config.getDBPassword();
            try {
                String driverName = Config.getDBDriverClass();
                Class.forName(driverName);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            try {
                connection = DriverManager.getConnection(url, user, password);
            }
            catch (SQLException e) {
                e.printStackTrace();
                if (!e.getMessage().startsWith("The database is already in use")) break block4;
                System.out.println("throwing new DatabaseInUseException");
                throw new DatabaseInUseException(e);
            }
        }
    }

    public static Connection getConnection() {
        return connection;
    }

    public static void closeConnection() {
        try {
            DBConnection.getConnection().close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    static {
        DBConnection.initialize();
    }
}

