/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.io.protocol.messages;

import com.jslope.io.protocol.impl.Serializer;
import com.jslope.io.protocol.messages.AbstractSignedMessage;
import com.jslope.io.protocol.messages.AttachmentObject;
import com.jslope.io.protocol.messages.FileAttachmentObject;
import com.jslope.io.protocol.messages.OpenMessage;
import com.jslope.io.stream.AdvancedDataInput;
import com.jslope.io.stream.AdvancedDataOutput;
import com.jslope.io.utils.IOUtils;
import com.jslope.security.PublicID;
import com.jslope.security.impl.IDFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DefaultOpenMessage
extends AbstractSignedMessage
implements OpenMessage {
    PublicID source;
    PublicID destination;
    String subject;
    String messageText;
    List<AttachmentObject> attachements = null;
    static final byte UNDEFINED_MESSAGE = 0;
    static final byte TECHNICAL_MESSAGE = 1;
    static final byte MAIL_MESSAGE = 2;
    byte messageType = 0;

    private DefaultOpenMessage() {
        this.messageType = 1;
    }

    public DefaultOpenMessage(PublicID soucreID, PublicID destinationID, String subjectText, String textMessage) {
        this.messageType = (byte)2;
        this.source = soucreID;
        this.destination = destinationID;
        this.subject = subjectText;
        this.messageText = textMessage;
    }

    @Override
    public String getString() {
        return this.messageText;
    }

    @Override
    protected void serializeUnsigned(AdvancedDataOutput dos) throws IOException {
        dos.writeByte(this.messageType);
        switch (this.messageType) {
            case 2: {
                this.source.serialize(dos);
                this.destination.serialize(dos);
                dos.writeUTF(this.subject);
                dos.writeUTF(this.messageText);
                if (this.attachements != null) {
                    dos.writeInt(this.attachements.size());
                    for (AttachmentObject attObj : this.attachements) {
                        attObj.serialize(dos);
                    }
                    break;
                }
                dos.writeInt(0);
            }
        }
    }

    @Override
    protected void deserializeUnsigned(AdvancedDataInput is) throws IOException {
        this.messageType = is.readByte();
        switch (this.messageType) {
            case 2: {
                this.source = IDFactory.deserializePublicID(is);
                this.destination = IDFactory.deserializePublicID(is);
                this.subject = is.readUTF();
                this.messageText = is.readUTF();
                this.attachements = new ArrayList<AttachmentObject>();
                int numberOfAttachments = is.readInt();
                for (int i = 0; i < numberOfAttachments; ++i) {
                    FileAttachmentObject attObj = new FileAttachmentObject();
                    attObj.deserialize(is);
                    this.attachements.add(attObj);
                }
                break;
            }
        }
    }

    public static OpenMessage newFromBytes(byte[] encryptedBytes) {
        DefaultOpenMessage openMessage = new DefaultOpenMessage();
        Serializer.deserialize(openMessage, encryptedBytes);
        return openMessage;
    }

    @Override
    public PublicID getDestinationID() {
        return this.destination;
    }

    @Override
    public boolean isSigned() {
        return this.signature != null;
    }

    @Override
    public PublicID getFromID() {
        return this.source;
    }

    @Override
    public String getText() {
        return this.messageText;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public List<AttachmentObject> getAttachments() {
        return this.attachements;
    }

    @Override
    public void setAttachments(Iterable<File> files) {
        List<AttachmentObject> objs = DefaultOpenMessage.loadAttachments(files);
        this.setAttachments(objs);
    }

    @Override
    public void setAttachments(List<AttachmentObject> objs) {
        this.attachements = objs;
    }

    public static List<AttachmentObject> loadAttachments(File[] files) {
        return DefaultOpenMessage.loadAttachments(Arrays.asList(files));
    }

    public static List<AttachmentObject> loadAttachments(Iterable<File> files) {
        ArrayList<AttachmentObject> objs = new ArrayList<AttachmentObject>();
        for (File file : files) {
            objs.add(DefaultOpenMessage.loadFile(file));
        }
        return objs;
    }

    private static AttachmentObject loadFile(File file) {
        byte[] bytes = IOUtils.loadFile(file);
        FileAttachmentObject attObj = new FileAttachmentObject();
        attObj.setFile(file.getName(), bytes);
        return attObj;
    }

    @Override
    public byte[] getUnsignedBytes() {
        return new byte[0];
    }
}

