/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.io.protocol.impl.client2client;

import com.jslope.io.protocol.Address;
import com.jslope.io.protocol.errorhandling.ErrorHandler;
import com.jslope.io.protocol.impl.client2client.C2CProtocol;
import com.jslope.io.protocol.impl.client2client.C2CServerThread;
import com.jslope.io.protocol.impl.client2client.Client2ClientClientAction;
import com.jslope.io.protocol.impl.client2client.Client2ClientServerAction;
import com.jslope.security.SecureID;
import java.io.IOException;
import java.net.ServerSocket;

public class Client2ClientProtocol {
    static final int DEFAULT_SERVER_PORT = 2085;

    public static void startServer(SecureID secureID, String connectToIDName, Client2ClientServerAction serverAction) {
        Client2ClientProtocol.startMultithreadServer(secureID, serverAction, connectToIDName, 2085);
    }

    public static void startServer(SecureID secureID, String connectToIDName, Client2ClientServerAction serverAction, int port) {
        Client2ClientProtocol.startMultithreadServer(secureID, serverAction, connectToIDName, port);
    }

    private static void startMultithreadServer(SecureID secureID, Client2ClientServerAction serverAction, String connectToIDName, int serverPort) {
        try {
            ServerSocket serverSocket = new ServerSocket(serverPort);
            System.out.println("C2C Server started, listening on port " + serverPort);
            while (true) {
                new C2CServerThread(serverSocket.accept(), secureID, connectToIDName, serverAction).start();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    public static void c2cClient(SecureID secureID, Address address, String connectToIDName, Client2ClientClientAction action, ErrorHandler errorHandler) {
        if (!address.hasPort()) {
            address.setPort(2085);
        }
        C2CProtocol protocol = new C2CProtocol(secureID, connectToIDName, errorHandler);
        protocol.startClient(address, action);
    }
}

