/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.io.protocol.impl.actions;

import com.jslope.io.protocol.ClientProtocol;
import com.jslope.io.protocol.ProtocolConstants;
import com.jslope.io.protocol.ServerProtocol;
import com.jslope.io.protocol.exceptions.ActionException;
import com.jslope.io.protocol.impl.actions.ProtocolAction;
import com.jslope.io.stream.DataTransport;
import com.jslope.security.Domain;
import com.jslope.security.PublicDomain;
import com.jslope.security.crypto.impl.CryptogException;
import com.jslope.security.crypto.utils.JSlopeRandom;
import java.io.IOException;

public class VerifyClientDomainAction
implements ProtocolAction {
    @Override
    public void doServerSide(ServerProtocol parentProtocol) throws IOException, ActionException, CryptogException {
        DataTransport tr = parentProtocol.getTransport();
        PublicDomain publicDomain = parentProtocol.getConnectedDomain();
        byte[] randomBytes = JSlopeRandom.getRandom(1024);
        tr.writeBytes(randomBytes);
        byte[] signature = tr.readBytes();
        boolean signatureIsOk = publicDomain.verifySignature(randomBytes, signature);
        if (signatureIsOk) {
            tr.writeByte((byte)1);
        } else {
            tr.writeByte((byte)12);
            parentProtocol.throwActionException("Bad signature", "Bad signature on client side for domain: " + publicDomain.getName());
        }
    }

    @Override
    public void doClientSide(ClientProtocol parentProtocol) throws IOException, ActionException, CryptogException {
        DataTransport tr = parentProtocol.getTransport();
        byte[] bytesToSign = tr.readBytes();
        Domain domain = (Domain)parentProtocol.getValue(ProtocolConstants.DOMAIN_TO_CONNECT);
        byte[] signature = domain.signLowLevelBytes(bytesToSign);
        tr.writeBytes(signature);
        byte retValue = tr.readByte();
        if (retValue != 1) {
            parentProtocol.throwActionException("Bad signature", "Bad signature on client side for domain: " + domain.getName());
        }
    }
}

