/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.io.protocol.impl.actions;

import com.jslope.io.protocol.ClientProtocol;
import com.jslope.io.protocol.ProtocolConstants;
import com.jslope.io.protocol.ServerProtocol;
import com.jslope.io.protocol.exceptions.ActionException;
import com.jslope.io.protocol.impl.actions.ProtocolAction;
import com.jslope.io.stream.DataTransport;
import com.jslope.logger.Log;
import com.jslope.security.Domain;
import com.jslope.security.PublicID;
import com.jslope.security.crypto.impl.CryptogException;
import com.jslope.security.impl.IDFactory;
import java.io.IOException;
import java.util.Set;

public class SignIDForServerAction
implements ProtocolAction {
    @Override
    public void doServerSide(ServerProtocol parentProtocol) throws IOException, ActionException, CryptogException {
        DataTransport tr = parentProtocol.getTransport();
        int size = tr.readInt();
        Log.debug("Will receive " + size + " public IDs to be installed");
        for (int i = 0; i < size; ++i) {
            PublicID publicID = IDFactory.deserializePublicID(tr);
            if (!publicID.verifyInternalSignature()) {
                throw new CryptogException("Signature verification failed for ID " + publicID);
            }
            parentProtocol.getServerHandler().createAccountOnServer(publicID);
            parentProtocol.getServerHandler().removeUnsignedID(publicID.getName());
        }
        tr.writeByte((byte)1);
    }

    @Override
    public void doClientSide(ClientProtocol parentProtocol) throws IOException, ActionException, CryptogException {
        DataTransport tr = parentProtocol.getTransport();
        Domain domain = (Domain)parentProtocol.getValue(ProtocolConstants.DOMAIN_TO_CONNECT);
        Set unsignedIDs = (Set)parentProtocol.getValue(ProtocolConstants.UNSIGNED_ID);
        Log.debug("Now will sign ID for server, we have " + unsignedIDs.size() + " unsigned ids");
        tr.writeInt(unsignedIDs.size());
        for (PublicID unsignedID : unsignedIDs) {
            String idName = unsignedID.getName();
            Log.debug("Now will sign id " + idName);
            domain.signID(unsignedID);
            Log.debug("Id " + idName + " signed successfully");
            unsignedID.serialize(tr);
            Log.debug("Signed id " + idName + " sent to server");
        }
        Boolean retVal = tr.readByte() == 1;
        parentProtocol.setValue(ProtocolConstants.BOOLEAN_RESULT, retVal);
    }
}

