/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.io.protocol.impl.actions;

import com.jslope.io.protocol.ClientProtocol;
import com.jslope.io.protocol.ProtocolConstants;
import com.jslope.io.protocol.ServerHandler;
import com.jslope.io.protocol.ServerProtocol;
import com.jslope.io.protocol.exceptions.ActionException;
import com.jslope.io.protocol.impl.actions.ProtocolAction;
import com.jslope.io.stream.DataTransport;
import com.jslope.security.PublicID;
import com.jslope.security.crypto.impl.CryptogException;
import java.io.IOException;

public class SaveUnsignedIDonServerAction
implements ProtocolAction {
    @Override
    public void doServerSide(ServerProtocol parentProtocol) throws IOException, ActionException, CryptogException {
        DataTransport tr = parentProtocol.getTransport();
        ServerHandler serverHandler = parentProtocol.getServerHandler();
        PublicID unsignedID = (PublicID)parentProtocol.getValue(ProtocolConstants.UNSIGNED_ID);
        String secretKey = (String)parentProtocol.getValue(ProtocolConstants.SECRET_KEY);
        if (serverHandler.idPermitExists(unsignedID.getName(), secretKey)) {
            serverHandler.installUnsignedID(unsignedID);
            tr.writeByte((byte)1);
        } else {
            System.out.println("ID " + unsignedID.getName() + " with secret key " + secretKey + " was not found on server");
            tr.writeByte((byte)2);
        }
    }

    @Override
    public void doClientSide(ClientProtocol parentProtocol) throws IOException, ActionException, CryptogException {
        DataTransport tr = parentProtocol.getTransport();
        byte result = tr.readByte();
        if (result == 2) {
            parentProtocol.addError("Installation failed", "Installation Failed for " + parentProtocol.getValue(ProtocolConstants.UNSIGNED_ID));
        }
        Boolean retVal = result == 1;
        parentProtocol.setValue(ProtocolConstants.BOOLEAN_RESULT, retVal);
    }
}

