/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.io.protocol.impl.actions;

import com.jslope.io.protocol.ClientProtocol;
import com.jslope.io.protocol.ProtocolConstants;
import com.jslope.io.protocol.ServerHandler;
import com.jslope.io.protocol.ServerProtocol;
import com.jslope.io.protocol.exceptions.ActionException;
import com.jslope.io.protocol.impl.actions.ProtocolAction;
import com.jslope.io.stream.DataTransport;
import com.jslope.logger.Log;
import com.jslope.security.IDPermit;
import com.jslope.security.PublicDomain;
import com.jslope.security.PublicID;
import com.jslope.security.crypto.impl.CryptogException;
import com.jslope.security.impl.IDFactory;
import com.jslope.security.impl.JSlopeIDPermit;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class RetrieveUnsignedIDFromServerAction
implements ProtocolAction {
    @Override
    public void doServerSide(ServerProtocol parentProtocol) throws IOException, ActionException, CryptogException {
        PublicDomain domain = parentProtocol.getConnectedDomain();
        ServerHandler handler = parentProtocol.getServerHandler();
        DataTransport tr = parentProtocol.getTransport();
        Set<PublicID> unsignedIDs = handler.getUnsignedIDsForDomain(domain);
        tr.writeInt(unsignedIDs.size());
        for (PublicID unsignedID : unsignedIDs) {
            IDPermit idPermit = handler.getIDPermit(unsignedID.getName());
            if (idPermit.getDomain().isEqual(domain)) {
                tr.writeByte((byte)1);
                idPermit.serialize(tr);
                unsignedID.serialize(tr);
                continue;
            }
            tr.writeByte((byte)13);
        }
    }

    @Override
    public void doClientSide(ClientProtocol parentProtocol) throws IOException, ActionException, CryptogException {
        DataTransport tr = parentProtocol.getTransport();
        PublicDomain publicDomain = parentProtocol.getPublicDomainToConnect();
        int howManyIDs = tr.readInt();
        HashSet<PublicID> unsignedIDs = new HashSet<PublicID>();
        block4: for (int i = 0; i < howManyIDs; ++i) {
            byte retValue = tr.readByte();
            switch (retValue) {
                case 1: {
                    JSlopeIDPermit idPermit = new JSlopeIDPermit();
                    idPermit.deserialize(tr);
                    if (idPermit.getDomain().isEqual(publicDomain)) {
                        if (idPermit.verifySignature()) {
                            PublicID unsignedID = IDFactory.deserializePublicID(tr);
                            unsignedIDs.add(unsignedID);
                            Log.debug("Received ID for signing: " + unsignedID);
                            continue block4;
                        }
                        parentProtocol.throwActionException("Signature verification failed", "Signature verification for ID permit for " + idPermit.getIDName() + " failed");
                        continue block4;
                    }
                    this.addDomainNotMatchError(parentProtocol);
                    continue block4;
                }
                case 13: {
                    this.addDomainNotMatchError(parentProtocol);
                }
            }
        }
        parentProtocol.setValue(ProtocolConstants.UNSIGNED_ID, unsignedIDs);
    }

    private void addDomainNotMatchError(ClientProtocol parentProtocol) throws ActionException {
        parentProtocol.throwActionException("Domains not match", "Domain with which was signed id permit is not the same as requesting now to sign id");
    }
}

