/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.io.protocol.impl.actions;

import com.jslope.io.protocol.ClientProtocol;
import com.jslope.io.protocol.ProtocolConstants;
import com.jslope.io.protocol.ServerHandler;
import com.jslope.io.protocol.ServerProtocol;
import com.jslope.io.protocol.exceptions.ActionException;
import com.jslope.io.protocol.impl.actions.ProtocolAction;
import com.jslope.io.stream.DataTransport;
import com.jslope.security.PublicID;
import com.jslope.security.impl.IDFactory;
import java.io.IOException;

public class ReceiveIDAction
implements ProtocolAction {
    @Override
    public void doServerSide(ServerProtocol parentProtocol) throws IOException, ActionException {
        String idName;
        DataTransport tr = parentProtocol.getTransport();
        ServerHandler serverHandler = parentProtocol.getServerHandler();
        if (serverHandler.isIdInstalled(idName = tr.readUTF())) {
            tr.writeByte((byte)8);
            PublicID publicID = serverHandler.getInstalledID(idName);
            publicID.serialize(tr);
        } else {
            tr.writeByte((byte)9);
        }
    }

    @Override
    public void doClientSide(ClientProtocol parentProtocol) throws IOException, ActionException {
        DataTransport tr = parentProtocol.getTransport();
        String idName = (String)parentProtocol.getValue(ProtocolConstants.ID_NAME);
        tr.writeUTF(idName);
        byte retVal = tr.readByte();
        if (retVal == 8) {
            PublicID publicID = IDFactory.deserializePublicID(tr);
            parentProtocol.setValue(ProtocolConstants.PUBLIC_ID, publicID);
        } else {
            parentProtocol.throwActionException("ID not found", "ID " + idName + " not found on server");
        }
    }
}

