/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.io.protocol.impl;

import com.jslope.io.stream.AdvancedByteDataInput;
import com.jslope.io.stream.AdvancedByteDataOutput;
import com.jslope.io.stream.AdvancedDataInput;
import com.jslope.io.stream.AdvancedDataOutput;
import com.jslope.io.stream.DataTransport;
import com.jslope.io.stream.impl.AdvancedByteDataInputStream;
import com.jslope.io.stream.impl.AdvancedByteDataOutputStream;
import com.jslope.logger.Log;
import com.jslope.security.PublicID;
import com.jslope.security.crypto.JSlopeSymetricKey;
import com.jslope.security.crypto.impl.CryptogException;
import com.jslope.security.impl.IDFactory;
import java.io.IOException;

public class SecureTransport
implements DataTransport {
    private AdvancedByteDataInput inputCache = null;
    private AdvancedByteDataOutput outputCache = new AdvancedByteDataOutputStream();
    private DataTransport tr;
    private JSlopeSymetricKey key;

    SecureTransport(DataTransport parent, JSlopeSymetricKey simmetrycKey) {
        this.tr = parent;
        this.key = simmetrycKey;
    }

    private AdvancedDataInput in() throws IOException {
        this.flush();
        if (this.inputCache == null) {
            this.refillInputCache();
        } else if (!this.inputCache.haveBytes()) {
            this.refillInputCache();
        }
        if (this.inputCache == null) {
            Log.debug("ERROR: input cache is still null when it shouldn't be");
        }
        return this.inputCache;
    }

    @Override
    public void flush() throws IOException {
        if (this.outputCache.size() > 0) {
            try {
                byte[] bytes = this.outputCache.toByteArray();
                this.outputCache.reset();
                byte[] encryptedBytes = this.key.encrypt(bytes);
                this.tr.writeBytes(encryptedBytes);
                this.tr.flush();
            }
            catch (CryptogException e) {
                e.printStackTrace();
                throw new RuntimeException("Exception during encryption of output stream", e);
            }
        }
    }

    private void refillInputCache() throws IOException {
        byte[] encryptedBytes = this.tr.readBytes();
        try {
            this.inputCache = new AdvancedByteDataInputStream(this.key.decrypt(encryptedBytes));
        }
        catch (CryptogException e) {
            e.printStackTrace();
            new RuntimeException("Crypto exception occurind during reading", e);
        }
    }

    private AdvancedDataOutput out() throws IOException {
        this.checkInputCache();
        return this.outputCache;
    }

    private void checkInputCache() throws IOException {
        if (this.inputCache != null && this.inputCache.haveBytes()) {
            throw new IOException("Input has cache has bytes while already waiting for output");
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.tr.close();
    }

    @Override
    public void writePublicID(PublicID publicPart) throws IOException {
        publicPart.serialize(this.out());
    }

    @Override
    public PublicID readPublicID() throws IOException {
        return IDFactory.deserializePublicID(this.in());
    }

    @Override
    public String readUTF() throws IOException {
        return this.in().readUTF();
    }

    @Override
    public long readLong() throws IOException {
        return this.in().readLong();
    }

    @Override
    public byte readByte() throws IOException {
        return this.in().readByte();
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.in().readBoolean();
    }

    @Override
    public byte[] readBytes() throws IOException {
        return this.in().readBytes();
    }

    @Override
    public int readInt() throws IOException {
        return this.in().readInt();
    }

    @Override
    public void writeUTF(String string) throws IOException {
        this.out().writeUTF(string);
    }

    @Override
    public void writeLong(long signatureTime) throws IOException {
        this.out().writeLong(signatureTime);
    }

    @Override
    public void writeBytes(byte[] bytes) throws IOException {
        this.out().writeBytes(bytes);
    }

    @Override
    public void writeBoolean(boolean value) throws IOException {
        this.out().writeBoolean(value);
    }

    @Override
    public void writeByte(byte byteValue) throws IOException {
        this.out().writeByte(byteValue);
    }

    @Override
    public void writeByte(int byteValue) throws IOException {
        this.out().writeByte(byteValue);
    }

    @Override
    public void writeInt(int value) throws IOException {
        this.out().writeInt(value);
    }
}

