/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.io.protocol.impl;

import com.jslope.io.Config;
import com.jslope.io.protocol.Address;
import com.jslope.io.protocol.Protocol;
import com.jslope.io.protocol.ProtocolConstants;
import com.jslope.io.protocol.ProtocolListener;
import com.jslope.io.protocol.ServerHandler;
import com.jslope.io.protocol.errorhandling.ErrorHandler;
import com.jslope.io.protocol.exceptions.ActionException;
import com.jslope.io.protocol.impl.IODataTransport;
import com.jslope.io.protocol.impl.ProtocolKeeper;
import com.jslope.io.protocol.impl.actions.ProtocolAction;
import com.jslope.io.protocol.impl.actions.SwitchAction;
import com.jslope.io.stream.DataTransport;
import com.jslope.logger.Log;
import com.jslope.security.PublicDomain;
import com.jslope.security.crypto.impl.CryptogException;
import java.io.IOException;
import java.net.Socket;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractProtocol
implements Protocol {
    List<ProtocolAction> protocolStack;
    Map<ProtocolConstants, Object> valueMap = new EnumMap<ProtocolConstants, Object>(ProtocolConstants.class);
    private volatile boolean isInitializing = false;
    DataTransport transport;
    ErrorHandler errorHandler;
    String connectedToIP = null;
    Class<? extends AbstractProtocol> parent = null;
    ServerHandler serverHandler = null;
    Set<ProtocolListener> protocolListeners = new HashSet<ProtocolListener>();
    Set<String> verifiedDomainSet = new HashSet<String>();

    public void setInitializingTrue() {
        this.isInitializing = true;
    }

    public void setProtocolStack() {
        this.protocolStack = ProtocolKeeper.getProtocolStack(this.getClass());
    }

    @Override
    public void setValue(ProtocolConstants name, Object value) {
        this.valueMap.put(name, value);
    }

    @Override
    public Object getValue(ProtocolConstants name) {
        return this.valueMap.get((Object)name);
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    @Override
    public DataTransport getTransport() {
        return this.transport;
    }

    @Override
    public void setTransport(DataTransport tr) {
        this.transport = tr;
    }

    @Override
    public void serverSideStart(DataTransport transport) throws IOException {
        this.transport = transport;
        this.serverSideProcess(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serverSideProcess(Class<? extends AbstractProtocol> protocolClass) throws IOException {
        List<ProtocolAction> actions = ProtocolKeeper.getProtocolActions(protocolClass);
        try {
            for (ProtocolAction action : actions) {
                action.doServerSide(this);
                if (!this.errorHandler.hasErrors()) continue;
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.addError(e);
        }
        catch (ActionException e) {
            e.printStackTrace();
        }
        catch (CryptogException e) {
            e.printStackTrace();
            this.addError(e);
        }
        finally {
            this.getTransport().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean clientSideStart(Address serverAddress) {
        System.out.println("Connecting to server with address: " + serverAddress);
        if (this.connectToServer(serverAddress)) {
            List<ProtocolAction> actions = ProtocolKeeper.getProtocolStack(this.getClass());
            try {
                for (ProtocolAction action : actions) {
                    action.doClientSide(this);
                    if (!this.errorHandler.hasErrors()) continue;
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.errorHandler.addError(e);
            }
            catch (ActionException e) {
                e.printStackTrace();
            }
            catch (CryptogException e) {
                e.printStackTrace();
                this.addError(e);
            }
            finally {
                try {
                    this.getTransport().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.errorHandler.addError("Exception during closing transport", "Exception during closing transport", e);
                }
            }
        }
        return !this.errorHandler.hasErrors();
    }

    private boolean connectToServer(Address serverAddress) {
        Socket socket = null;
        try {
            this.connectedToIP = serverAddress.toString();
            socket = serverAddress.connect();
            this.transport = new IODataTransport(socket);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.errorHandler.addError("Unable to connect to server", "Unable to connect to server at address: " + serverAddress + " using port " + Config.getPort(), e);
            return false;
        }
        return true;
    }

    protected void addSwitch(Class<? extends AbstractProtocol> ... protocolClasses) {
        assert (this.isInitializing);
        try {
            this.add(new SwitchAction(protocolClasses));
            for (Class<? extends AbstractProtocol> protocolClass : protocolClasses) {
                AbstractProtocol protocol = protocolClass.newInstance();
                protocol.setParent(this.getClass());
                protocol.initialize();
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            Log.error(e);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            Log.error(e);
        }
    }

    protected void add(ProtocolAction action) {
        if (!this.isInitializing) {
            throw new RuntimeException("Attemt to add element to protocol while isInitialazing == false");
        }
        ProtocolKeeper.addAction(this.getClass(), action);
    }

    @Override
    public void addError(Exception e) {
        this.errorHandler.addError(e);
    }

    @Override
    public void addError(String shortDescription, String longDescription, Exception e) {
        this.errorHandler.addError(shortDescription, longDescription, e);
    }

    @Override
    public void addError(String shortDescription, String longDescription) {
        this.errorHandler.addError(shortDescription, longDescription);
    }

    @Override
    public void throwActionException(String shortDescr, String longDescr) throws ActionException {
        this.addError(shortDescr, longDescr);
        throw new ActionException(longDescr);
    }

    public void setParent(Class<? extends AbstractProtocol> newProtocol) {
        this.parent = newProtocol;
    }

    public void initialize() {
        this.isInitializing = true;
        ProtocolKeeper.setParent(this.getClass(), this.parent);
        this.init();
        ProtocolKeeper.protocolFinishedInit(this.getClass(), this.parent);
        this.isInitializing = false;
    }

    @Override
    public ServerHandler getServerHandler() {
        return this.serverHandler;
    }

    public void setServerHandler(ServerHandler realServerHandler) {
        this.serverHandler = realServerHandler;
    }

    @Override
    public String getConnectedToIP() {
        return this.connectedToIP;
    }

    protected abstract void init();

    public void setRemoteIP(String hostAddress) {
        this.connectedToIP = hostAddress;
    }

    @Override
    public void addProtocolListener(ProtocolListener protocolListener) {
        this.protocolListeners.add(protocolListener);
    }

    @Override
    public boolean getBooleanResult() {
        if (this.errorHandler.hasErrors()) {
            return false;
        }
        Object value = this.getValue(ProtocolConstants.BOOLEAN_RESULT);
        return (Boolean)value;
    }

    @Override
    public PublicDomain getConnectedDomain() {
        return (PublicDomain)this.getValue(ProtocolConstants.PUBLIC_DOMAIN_TO_VERIFY);
    }

    @Override
    public PublicDomain getPublicDomainToConnect() {
        return (PublicDomain)this.getValue(ProtocolConstants.PUBLIC_DOMAIN_TO_CONNECT);
    }

    @Override
    public void storeVerifiedDomain(PublicDomain domain) {
        this.verifiedDomainSet.add(domain.getName());
    }

    @Override
    public boolean isDomainVerified(PublicDomain domain) {
        return this.verifiedDomainSet.contains(domain.getName());
    }
}

