/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.io.protocol;

import com.jslope.io.Config;
import com.jslope.io.stream.AdvancedDataInput;
import com.jslope.io.stream.AdvancedDataOutput;
import com.jslope.io.stream.StreamSerializable;
import java.io.IOException;
import java.net.Socket;

public class Address
implements StreamSerializable {
    private String address;
    static final int NULL_PORT = 0;
    private int port = 0;

    public Address() {
    }

    public Address(String adr) {
        this.parse(adr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parse(String adr) {
        if (adr.contains(":")) {
            String[] divided = adr.split(":");
            if (divided.length != 2) throw new AddressParsingException("Can not parse adr " + adr);
            this.address = divided[0];
            this.port = Integer.parseInt(divided[1]);
            return;
        } else {
            this.address = adr;
        }
    }

    public Socket connect() throws IOException {
        if (this.port == 0) {
            return new Socket(this.address, Config.getPort());
        }
        return new Socket(this.address, this.port);
    }

    @Override
    public void serialize(AdvancedDataOutput os) throws IOException {
        os.writeUTF(this.address);
        os.writeInt(this.port);
    }

    @Override
    public void deserialize(AdvancedDataInput is) throws IOException {
        this.address = is.readUTF();
        this.port = is.readInt();
    }

    public String toString() {
        if (this.port == 0) {
            return this.address;
        }
        return this.address + ":" + this.port;
    }

    public int getPort() {
        return this.port;
    }

    public String getAddress() {
        return this.address;
    }

    public boolean hasPort() {
        return this.port != 0;
    }

    public void setPort(int newPort) {
        this.port = newPort;
    }

    class AddressParsingException
    extends RuntimeException {
        AddressParsingException(String s) {
            super(s);
        }
    }
}

