/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.framework;

import com.jslope.framework.DNS;
import com.jslope.io.protocol.Protocol;
import com.jslope.io.protocol.ProtocolConstants;
import com.jslope.io.protocol.Protocols;
import com.jslope.io.protocol.errorhandling.ErrorHandler;
import com.jslope.io.protocol.messages.MailMessage;
import com.jslope.security.IDSignedByDomain;
import com.jslope.security.SecureID;
import com.jslope.security.impl.IDFactory;
import com.jslope.security.impl.JSlopeSecureID;
import java.util.ArrayList;
import java.util.List;

public class IDManager {
    public static boolean sendMessage(MailMessage messageToSend, SecureID secureID, ErrorHandler errorHandler) {
        ArrayList<MailMessage> list = new ArrayList<MailMessage>();
        list.add(messageToSend);
        return IDManager.sendMessage(list, secureID, errorHandler);
    }

    public static boolean sendMessageServer2Server(MailMessage messageToSend, IDSignedByDomain fromDomainID, ErrorHandler errorHandler) {
        ArrayList<MailMessage> list = new ArrayList<MailMessage>();
        list.add(messageToSend);
        return IDManager.sendMessageServer2Server(list, fromDomainID, errorHandler);
    }

    public static boolean sendMessageServer2Server(List<MailMessage> messagesToSend, IDSignedByDomain fromDomainID, ErrorHandler errorHandler) {
        Protocol protocol = Protocols.getSendMessagesServer2ServerProtocol();
        protocol.setErrorHandler(errorHandler);
        protocol.setValue(ProtocolConstants.MAIL_MESSAGES, messagesToSend);
        protocol.setValue(ProtocolConstants.ID_SIGNED_BY_DOMAIN, fromDomainID);
        String destinationDomainName = messagesToSend.get(0).getDestinationID().getDomain().getName();
        protocol.setValue(ProtocolConstants.DOMAIN_NAME_TO_CONNECT, destinationDomainName);
        protocol.clientSideStart(DNS.getAddress(destinationDomainName));
        return protocol.getBooleanResult();
    }

    public static boolean sendMessage(List<MailMessage> messagesToSend, SecureID secureID, ErrorHandler errorHandler) {
        Protocol protocol = Protocols.getSendMessagesProtocol();
        protocol.setErrorHandler(errorHandler);
        protocol.setValue(ProtocolConstants.MAIL_MESSAGES, messagesToSend);
        protocol.clientSideStart(DNS.getAddress(IDFactory.getDomainName(secureID.getName())));
        return protocol.getBooleanResult();
    }

    public static List<MailMessage> receiveMessages(JSlopeSecureID secureID, ErrorHandler errorHandler) {
        Protocol protocol = Protocols.getReceiveMessagesProtocol();
        protocol.setErrorHandler(errorHandler);
        protocol.setValue(ProtocolConstants.SECURE_ID, secureID);
        protocol.clientSideStart(DNS.getAddress(IDFactory.getDomainName(secureID.getName())));
        return (List)protocol.getValue(ProtocolConstants.MAIL_MESSAGES);
    }
}

