/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.framework;

import com.jslope.io.protocol.Address;
import com.jslope.io.protocol.Protocol;
import com.jslope.io.protocol.ProtocolConstants;
import com.jslope.io.protocol.Protocols;
import com.jslope.io.protocol.errorhandling.ErrorHandler;
import com.jslope.io.protocol.errorhandling.impl.TextErrorHandler;
import com.jslope.security.AddressSignedByDomain;
import com.jslope.security.PublicID;
import com.jslope.security.crypto.impl.CryptogException;
import com.jslope.security.impl.IDFactory;
import com.jslope.security.impl.RootDomains;

public class DNS {
    public static Address getAddress(String domainName) {
        return DNS.getAddress(domainName, new TextErrorHandler());
    }

    public static Address getAddress(String domainName, ErrorHandler errorHandler) {
        if (DNS.itsRoot(domainName)) {
            return RootDomains.getAddress(domainName);
        }
        String parentDomain = DNS.getParentDomain(domainName);
        Address parentAddress = DNS.getAddress(parentDomain, errorHandler);
        if (parentAddress == null) {
            errorHandler.addAndThrow("Unable to find domain name", "Unable to find domain name \"" + domainName + "\" when looking for parent \"" + parentDomain + "\"");
        }
        Protocol protocol = Protocols.getDNSProtocol(domainName, errorHandler);
        protocol.clientSideStart(parentAddress);
        AddressSignedByDomain signedAddress = (AddressSignedByDomain)protocol.getValue(ProtocolConstants.ADDRESS);
        try {
            if (signedAddress.verifySignature()) {
                return signedAddress.getAddress();
            }
            errorHandler.addError("Domain signature didn't match", "Domain signature didn't match");
            throw new RuntimeException("Domain signature didn't match");
        }
        catch (CryptogException e) {
            e.printStackTrace();
            errorHandler.addError(e);
            throw new RuntimeException("Crypto exception", e);
        }
    }

    private static String getParentDomain(String domainName) {
        int dotIndex = domainName.indexOf(".") + 1;
        return domainName.substring(dotIndex);
    }

    private static boolean itsRoot(String domainName) {
        return !domainName.contains(".");
    }

    public static PublicID getID(String idName, ErrorHandler errorHandler) {
        String domainName = IDFactory.getDomainName(idName);
        Address serverAddress = DNS.getAddress(domainName, errorHandler);
        Protocol protocol = Protocols.getReceiveIDPorotocol();
        protocol.setErrorHandler(errorHandler);
        protocol.setValue(ProtocolConstants.ID_NAME, idName);
        protocol.clientSideStart(serverAddress);
        PublicID publicID = (PublicID)protocol.getValue(ProtocolConstants.PUBLIC_ID);
        try {
            if (publicID == null) {
                errorHandler.addAndThrow("Unable to receive id from server ", "Unable to receive  public id " + idName + "from server " + serverAddress);
            } else if (!publicID.verifyInternalSignature()) {
                errorHandler.addAndThrow("Signature verification error", "Signature verification error in public id" + idName);
            } else if (!publicID.getName().equals(idName)) {
                errorHandler.addAndThrow("Received and requested name don't match", "Received " + publicID.getName() + " while requested " + idName);
            }
        }
        catch (CryptogException e) {
            e.printStackTrace();
            errorHandler.addError(e);
            throw new RuntimeException(e);
        }
        return publicID;
    }
}

