/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.client.ui.persistent;

import com.jslope.client.ui.MainWindow;
import com.jslope.client.ui.model.AccountNode;
import com.jslope.client.ui.model.DirectoryTreeModel;
import com.jslope.client.ui.model.PersistentAccount;
import com.jslope.client.ui.persistent.DirectoryRecord;
import com.jslope.client.ui.persistent.PersistentDirectory;
import com.jslope.client.ui.persistent.PersistentTreeElement;
import com.jslope.framework.DNS;
import com.jslope.io.protocol.errorhandling.ErrorHandler;
import com.jslope.io.protocol.impl.Serializer;
import com.jslope.logger.Log;
import com.jslope.persistence.DBPersistentObject;
import com.jslope.persistence.ObjectList;
import com.jslope.persistence.fields.BlobField;
import com.jslope.persistence.fields.BooleanField;
import com.jslope.persistence.fields.VarcharField;
import com.jslope.persistence.sql.Condition;
import com.jslope.security.PublicID;
import com.jslope.security.SecureID;
import com.jslope.security.crypto.impl.CryptogException;
import com.jslope.security.impl.IDFactory;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class AccountRecord
extends DBPersistentObject
implements PersistentTreeElement,
PersistentAccount {
    private static final String ACCOUNT_NAME = "accountName";
    private static final String SECURE_ID = "secureID";
    private static final String IS_SIGNED = "issigned";
    public static final String OUTBOX = "Outbox";
    public static final String INBOX = "Inbox";
    public static final String DRAFTS = "Drafts";
    public static final String SENT = "Sent";
    public static final String TRASH = "Trash";
    static final AccountRecord workObject = new AccountRecord();
    private static boolean areThereSignedAccounts = false;

    @Override
    public void define() {
        this.addField(ACCOUNT_NAME, new VarcharField(355));
        this.getField(ACCOUNT_NAME).setUnique(true);
        this.addField(SECURE_ID, new BlobField());
        this.addField(IS_SIGNED, new BooleanField(false));
    }

    public String toString() {
        return this.get(ACCOUNT_NAME);
    }

    public String getIDName() {
        return this.get(ACCOUNT_NAME);
    }

    public static boolean accountExists(String accountName) {
        return workObject.objectExists(Condition.var(ACCOUNT_NAME).Equal(accountName));
    }

    public void setSecureID(SecureID secureID) {
        ((BlobField)this.getField(SECURE_ID)).setData(Serializer.serialize(secureID));
        this.setIsSigned(secureID.getPublicPart().isSigned());
    }

    private void setIsSigned(boolean isSigned) {
        ((BooleanField)this.getField(IS_SIGNED)).setValue(isSigned);
        if (isSigned) {
            areThereSignedAccounts = true;
        }
    }

    public SecureID getSecureID() {
        byte[] blobData = ((BlobField)this.getField(SECURE_ID)).getData();
        SecureID secureID = IDFactory.newID();
        Serializer.deserialize(secureID, blobData);
        return secureID;
    }

    public void setName(String name) {
        this.set(ACCOUNT_NAME, name);
    }

    public static List<AccountRecord> returnAll() {
        ArrayList<AccountRecord> accountList = new ArrayList<AccountRecord>();
        ObjectList objList = workObject.loadObjects();
        while (objList.hasNext()) {
            AccountRecord account = (AccountRecord)objList.next();
            accountList.add(account);
            if (!account.isSigned()) continue;
            areThereSignedAccounts = true;
        }
        return accountList;
    }

    public List<DirectoryRecord> getChilds() {
        return this.getChilds(false);
    }

    public List<DirectoryRecord> getChilds(boolean secondCycle) {
        List<DirectoryRecord> retVal = DirectoryRecord.getChildsOf(this.getID());
        if (retVal.size() != 5) {
            if (secondCycle) {
                throw new RuntimeException("The program was unable to generate children for " + this);
            }
            System.out.println("Now will generate dirs for ");
            this.generateChilds();
            return this.getChilds(true);
        }
        return retVal;
    }

    private void generateChilds() {
        DirectoryRecord.deleteAllChildsOf(this.getID());
        this.addNewSubdir(INBOX, 1);
        this.addNewSubdir(OUTBOX, 2);
        this.addNewSubdir(DRAFTS, 3);
        this.addNewSubdir(SENT, 4);
        this.addNewSubdir(TRASH, 5);
    }

    private void addNewSubdir(String name, int index) {
        DirectoryRecord dir = new DirectoryRecord();
        dir.setName(name);
        dir.setParent(this.getID(), index);
        dir.save();
    }

    public static AccountRecord getFirstAccount() {
        return AccountRecord.returnAll().iterator().next();
    }

    public DirectoryRecord getOutboxDir() {
        return DirectoryRecord.getOutboxFor(this.getID());
    }

    public DirectoryRecord getSentDirectory() {
        return DirectoryRecord.getSentFor(this.getID());
    }

    public DirectoryRecord getInboxDir() {
        return DirectoryRecord.getInboxtFor(this.getID());
    }

    @Override
    public PersistentDirectory getTrashDirectory() {
        return DirectoryRecord.getTrashFor(this.getID());
    }

    public PersistentDirectory getDraftsDir() {
        return DirectoryRecord.getDraftsFor(this.getID());
    }

    public static SecureID getSecureID(String name) {
        AccountRecord record = AccountRecord.getAccountRecord(name);
        return record.getSecureID();
    }

    public static AccountRecord getAccountRecord(String name) {
        return (AccountRecord)workObject.loadOneObject(Condition.var(ACCOUNT_NAME).Equal(name));
    }

    public boolean isSigned() {
        return this.getSecureID().getPublicPart().isSigned();
    }

    public void updateUI() {
        AccountNode node = AccountNode.getNode(this);
        if (node.isSelected()) {
            node.updateEditor();
        }
        DirectoryTreeModel.updateNode(node);
    }

    public static Iterable<? extends SecureID> getServersWithUnsignedIDs() {
        HashSet<SecureID> serverNames = new HashSet<SecureID>();
        ObjectList objectList = workObject.loadObjects(Condition.var(IS_SIGNED).Equal(0));
        while (objectList.hasNext()) {
            AccountRecord accRecord = (AccountRecord)objectList.next();
            serverNames.add(accRecord.getSecureID());
        }
        return serverNames;
    }

    private String getDomainName() {
        return IDFactory.getDomainName(this.getIDName());
    }

    public static void checkSignature(String idName) {
        AccountRecord.getAccountRecord(idName).checkSignature();
    }

    public static void checkSignature(AccountRecord accountRecord) {
        accountRecord.checkSignature();
    }

    public void checkSignature() {
        Log.debug("Checking signature for: " + this);
        ErrorHandler errorHandler = MainWindow.getNewSystemErrorHandler();
        if (this.isSigned()) {
            Log.debug("there is not need to check signature for " + this + " because it's already signed");
        } else {
            String idName = this.getSecureID().getName();
            PublicID publicID = DNS.getID(idName, MainWindow.getNewSystemErrorHandler());
            if (publicID != null && publicID.isSigned()) {
                SecureID secureID = this.getSecureID();
                try {
                    secureID.reintegrate(publicID);
                    this.setSecureID(secureID);
                    this.save();
                }
                catch (CryptogException e) {
                    e.printStackTrace();
                    errorHandler.addError(e);
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AccountRecord.this.updateUI();
                    }
                });
            } else {
                errorHandler.addError("ID is still not signed", "ID " + idName + " is still not signed");
            }
        }
    }

    public static boolean isIDSigned(String idName) {
        return AccountRecord.getSecureID(idName).getPublicPart().isSigned();
    }

    public static Iterable<? extends AccountRecord> allActiveAccounts() {
        ArrayList<AccountRecord> list = new ArrayList<AccountRecord>();
        for (AccountRecord record : AccountRecord.returnAll()) {
            if (!record.isSigned()) continue;
            list.add(record);
        }
        return list;
    }

    public static boolean areThereSignedAccounts() {
        return areThereSignedAccounts;
    }

    public String getName() {
        return this.getSecureID().getName();
    }
}

