/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.client.ui.model;

import com.jslope.client.ui.model.PersistentAccount;
import com.jslope.client.ui.persistent.AccountRecord;
import com.jslope.client.ui.persistent.MessageRecord;
import com.jslope.client.ui.persistent.PersistentDirectory;
import com.jslope.client.ui.view.ComposeMessageFrame;
import com.jslope.client.ui.view.Viewers;
import com.jslope.client.ui.view.ViewersPanel;
import com.jslope.client.ui.view.attachments.AttachmentList;
import com.jslope.client.ui.view.treeviewers.DirectoryViewer;
import java.util.Set;

public class Application {
    private static AccountRecord currentAccount = null;

    public static AccountRecord getCurrentAccount() {
        if (currentAccount == null) {
            return Application.getFirstAccount();
        }
        return currentAccount;
    }

    public static void setCurrentAccount(AccountRecord newSelectedAccount) {
        currentAccount = newSelectedAccount;
    }

    private static AccountRecord getFirstAccount() {
        return AccountRecord.getFirstAccount();
    }

    public static void createNewMessage() {
        AccountRecord account = Application.getCurrentAccount();
        MessageRecord parentMessage = new MessageRecord();
        parentMessage.setFrom(account.getName());
        parentMessage.setParent(account.getDraftsDir());
        parentMessage.save();
        ComposeMessageFrame messageFrame = new ComposeMessageFrame(parentMessage);
        messageFrame.setVisible(true);
        System.out.println("new message for account: " + account);
    }

    private static void replyToMessage(MessageRecord selectedMessage) {
        AccountRecord account = Application.getCurrentAccount();
        MessageRecord newMessage = new MessageRecord();
        newMessage.setFrom(account.getName());
        newMessage.setTo(selectedMessage.getFrom());
        newMessage.setSubject("Re: " + selectedMessage.getSubject());
        newMessage.setText(selectedMessage.getQuotedMessageText());
        newMessage.setParent(account.getDraftsDir());
        newMessage.save();
        Application.openMessageInEditor(newMessage);
    }

    public static void replyToMessage() {
        MessageRecord selectedMessage = Application.getSelectedMessage();
        if (selectedMessage != null) {
            Application.replyToMessage(selectedMessage);
        }
    }

    private static MessageRecord getSelectedMessage() {
        Viewers currentViewer;
        MessageRecord selectedMessage = null;
        if (currentAccount != null && (currentViewer = ViewersPanel.getInstance().getSelectedViewer()) != null && currentViewer == Viewers.DIRECTORY_VIEWER) {
            selectedMessage = Application.dirViewer().getSelectedMessage();
        }
        return selectedMessage;
    }

    public static boolean isMessageSelected() {
        Viewers currentViewer;
        if (currentAccount != null && (currentViewer = ViewersPanel.getInstance().getSelectedViewer()) != null && currentViewer == Viewers.DIRECTORY_VIEWER) {
            return Application.dirViewer().isMessageSelected();
        }
        return false;
    }

    public static DirectoryViewer dirViewer() {
        return (DirectoryViewer)Viewers.DIRECTORY_VIEWER.getViewer();
    }

    public static void deleteCurrentMessage() {
        Set<MessageRecord> selectedMessages = Application.dirViewer().deleteSelectedMessages();
        PersistentDirectory parentDir = null;
        PersistentDirectory trashDir = null;
        for (MessageRecord selectedMessage : selectedMessages) {
            if (selectedMessage == null) continue;
            parentDir = selectedMessage.getParent();
            if (parentDir.isTrashDirecotry()) {
                selectedMessage.deleteObject();
                continue;
            }
            PersistentAccount account = parentDir.getAccount();
            trashDir = account.getTrashDirectory();
            selectedMessage.setParent(trashDir);
            selectedMessage.save();
        }
        if (trashDir != null) {
            trashDir.updateUI();
        }
        if (parentDir != null) {
            parentDir.updateUI();
        }
    }

    public static void openMessage() {
        MessageRecord selectedMessage = Application.getSelectedMessage();
        PersistentDirectory parentDir = selectedMessage.getParent();
        if (parentDir.isDraftsDirecotry() || parentDir.isOutboxDirectory()) {
            Application.openMessageInEditor(selectedMessage);
        } else {
            System.out.println("This message should be open in read only frame, it will be done in later versions");
        }
    }

    private static void openMessageInEditor(MessageRecord selectedMessage) {
        ComposeMessageFrame messageFrame = new ComposeMessageFrame(selectedMessage);
        messageFrame.activateTextComponent();
        messageFrame.setVisible(true);
    }

    public static void saveOneAttachment() {
        AttachmentList.saveOneSelectedAttachment();
    }

    public static void saveAllAttachments() {
        AttachmentList.saveAllAttachmentsForCurrentList();
    }

    public static void deleteAttachment() {
        AttachmentList.deleteAttachment();
    }
}

