/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.client.ui.model;

import com.jslope.client.app.Icons;
import com.jslope.client.ui.model.AbstractDirectoryNode;
import com.jslope.client.ui.model.Directory;
import com.jslope.client.ui.model.DirectoryAccountTreeNode;
import com.jslope.client.ui.persistent.AccountRecord;
import com.jslope.client.ui.persistent.DirectoryRecord;
import com.jslope.client.ui.view.Viewers;
import com.jslope.client.ui.view.ViewersPanel;
import com.jslope.client.ui.view.treeviewers.AccountViewer;
import com.jslope.security.SecureID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public class AccountNode
extends AbstractDirectoryNode
implements DirectoryAccountTreeNode {
    AccountRecord record;
    List<DirectoryAccountTreeNode> childDirs;
    private static Map<String, AccountNode> recordToNode = null;

    public AccountNode() {
        this.record = new AccountRecord();
        this.initChilds();
    }

    public AccountNode(AccountRecord accountRecord) {
        this.record = accountRecord;
        this.initChilds();
    }

    private void initChilds() {
        List<DirectoryRecord> childDirRecords = this.record.getChilds();
        this.childDirs = new ArrayList<DirectoryAccountTreeNode>();
        for (DirectoryRecord dirRecord : childDirRecords) {
            Directory dir = new Directory(dirRecord);
            dir.setParent(this);
            this.childDirs.add(dir);
        }
    }

    @Override
    public DirectoryAccountTreeNode getChild(int index) {
        return this.childDirs.get(index);
    }

    @Override
    public int getChildCount() {
        if (this.record.isSigned()) {
            return this.childDirs.size();
        }
        return 0;
    }

    @Override
    public boolean isLeaf() {
        return !this.record.isSigned();
    }

    @Override
    public int getIndexOfChild(DirectoryAccountTreeNode child) {
        return this.childDirs.indexOf(child);
    }

    public AccountViewer getViewer() {
        return (AccountViewer)Viewers.ACCOUNT_VIEWER.getViewer();
    }

    @Override
    public void updateEditor() {
        this.getViewer().setIsSigned(this.record.isSigned());
        this.getViewer().setIDRecord(this.record);
        ViewersPanel.select(Viewers.ACCOUNT_VIEWER);
    }

    @Override
    public DirectoryAccountTreeNode getParent() {
        return this.parent;
    }

    public void setSecureID(SecureID secureID) {
        this.record.setSecureID(secureID);
    }

    public SecureID getSecureID() {
        return this.record.getSecureID();
    }

    public void setName(String name) {
        this.record.setName(name);
    }

    public void save() {
        this.record.save();
        recordToNode.put(this.record.getID(), this);
    }

    public String toString() {
        return this.record.toString();
    }

    public static List<DirectoryAccountTreeNode> loadAll() {
        recordToNode = new HashMap<String, AccountNode>();
        ArrayList<DirectoryAccountTreeNode> accountList = new ArrayList<DirectoryAccountTreeNode>();
        for (AccountRecord record : AccountRecord.returnAll()) {
            AccountNode node = new AccountNode(record);
            accountList.add(node);
            recordToNode.put(record.getID(), node);
        }
        return accountList;
    }

    public static AccountNode getNode(AccountRecord record) {
        return recordToNode.get(record.getID());
    }

    public static AccountNode getNode(String recordID) {
        return recordToNode.get(recordID);
    }

    public static boolean hasNodeWithID(String recordID) {
        return recordToNode.containsKey(recordID);
    }

    @Override
    public void removeChild(DirectoryAccountTreeNode node) {
    }

    public void delete() {
        this.record.deleteObject();
    }

    @Override
    public AccountRecord getParentAccount() {
        return this.record;
    }

    @Override
    public String getRecordID() {
        return this.record.getID();
    }

    @Override
    public boolean canCreateNewMessage() {
        return this.record.isSigned();
    }

    @Override
    public boolean canCheckMailForAnAccount() {
        return this.record.isSigned();
    }

    @Override
    public boolean canDeleteAnAccount() {
        return true;
    }

    @Override
    public Icon getIcon() {
        return Icons.account;
    }
}

