/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.client.ui;

import com.jslope.client.app.ErrorHandlerCreator;
import com.jslope.client.app.Options;
import com.jslope.client.io.serverlistener.ClientServerListener;
import com.jslope.client.io.serverlistener.ServerListener;
import com.jslope.client.protocol.UIErrorHandler;
import com.jslope.client.tree.TreePanel;
import com.jslope.client.ui.Menu;
import com.jslope.client.ui.model.DirectoryAccountTreeNode;
import com.jslope.client.ui.view.MainPanelView;
import com.jslope.client.ui.view.Viewers;
import com.jslope.io.protocol.errorhandling.ErrorHandler;
import com.jslope.persistence.sql.SqlUtil;
import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;

public class MainWindow
extends JFrame
implements ErrorHandlerCreator {
    private static MainWindow instance;

    private MainWindow() {
        this.init();
    }

    private void init() {
        this.setJMenuBar(Menu.getMenuBar());
        this.setDefaultCloseOperation(2);
        this.setContentPane(new MainPanelView());
        Options options = Options.getInstance();
        this.setLocation(options.getWindowLocation());
        this.setSize(options.getWindowSize());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                System.out.println("Window is closing, saving data...");
                Options options = Options.getInstance();
                options.setWindowLocation(MainWindow.this.getLocation());
                options.setWindowSize(MainWindow.this.getSize());
                options.setVerticalSplitPane(MainPanelView.getSplitPaneLocation());
                Viewers.DIRECTORY_VIEWER.getViewer().savePersistentState();
                DirectoryAccountTreeNode node = TreePanel.getSelectedNode();
                options.setSelectedNode(node);
                options.save();
                SqlUtil.closeDatabase();
                instance = null;
                System.exit(0);
            }
        });
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ServerListener.initSeverListener();
                ClientServerListener.initSeverListener();
            }
        });
    }

    public static MainWindow getInstance() {
        if (instance == null) {
            instance = new MainWindow();
        }
        return instance;
    }

    public static ErrorHandler getNewSystemErrorHandler() {
        return MainWindow.getInstance().getNewErrorHandler();
    }

    @Override
    public ErrorHandler getNewErrorHandler() {
        return new UIErrorHandler(this);
    }
}

